/* This file has been generated from the following Tcl source file(s): LINK_class.tcl
 * on Mon Feb  2 10:52:06 EST 2004 by abbottd
 */
#include <tcl.h>
static char initCmd[] = 
    "\n"
    "if {\"[info command LINK]\"!=\"LINK\"} {\n"
    "global tcl_modules\n"
    "\n"
    "lappend tcl_modules \"LINK_class.tcl {} {} {\\$Id: LINK_class.tcl,v 2.25 1998/07/27 19:17:45 heyes Exp $}\"\n"
    "\n"
    "class LINK {\n"
    "    constructor {session from to dir {callback \"\"} {host \"\"}} {}\n"
    "    destructor  {}\n"
    "\n"
    "    method constructor_C {session from to dir {callback \"\"} {host \"\"}} @LINK_constructor_C\n"
    "    method destructor_C  {} @LINK_destructor_C\n"
    "\n"
    "    method cons_connect    {} {} \n"
    "    method cons_disconnect {} {} \n"
    "    method read            {} {} \n"
    "    method prod_connect    {} {} \n"
    "\n"
    "    method prod_disconnect {} {} \n"
    "\n"
    "    method statistics {} {}\n"
    "    method fifo_stats {} @LINK_fifo_status\n"
    "    method get_outputH {} @LINK_get_outputH\n"
    "    \n"
    "    method  link_queue_name {} @LINK_queue_name\n"
    "	\n"
    "    public  variable state \"down\"\n"
    "    public  variable name  \"\"\n"
    "    public  variable ProcessDataC_call  \"\"\n"
    "    public  variable server \"\"\n"
    "    public  variable newFile \"\"\n"
    "    public  variable host \"\"\n"
    "    public  variable port \"\"\n"
    "    public  variable link {}\n"
    "    public  variable part\n"
    "    public  variable link_from\n"
    "    public  variable link_to\n"
    "    method   dalogmsg       {sev msg} @logmsgcmd\n"
    "\n"
    "    private variable direction \"\"\n"
    "    private method  AcceptLINKConnection {status file} {}\n"
    "    private method  ShutdownLINK {file} {}\n"
    "    private method  ProcessData {status file} @LINK_process_data\n"
    "    private method  startThread {file} @LINK_thread_init\n"
    "    method write {data} {}\n"
    "}\n"
    "\n"
    "body LINK::destructor {} {\n"
    "    if { \"$link\" != \"\"} {\n"
    "	ShutdownLINK $link\n"
    "    }\n"
    "    catch \"dp_atclose clear $newFile\"\n"
    "    catch \"dp_shutdown $newFile both\"\n"
    "    catch \"dp_filehandler $newFile\"\n"
    "    catch {dp_atexit delete \"close $newFile\"}\n"
    "    catch {close $newFile}\n"
    "\n"
    "    catch \"dp_atclose clear $server\"\n"
    "    catch \"dp_shutdown $server both\"\n"
    "    catch \"dp_filehandler $server\"\n"
    "    catch {dp_atexit delete \"close $server\"}\n"
    "    catch {close $server}\n"
    "\n"
    "    if { \"$direction\" == \"in\" } {\n"
    "	database query \"DELETE FROM links WHERE name='$name'\"\n"
    "    }\n"
    "\n"
    "    destructor_C\n"
    "\n"
    "}\n"
    "\n"
    "body LINK::constructor {session from to dir {callback \"\"} {host \"\"}} {\n"
    "    set type TCP\n"
    "    set direction $dir\n"
    "    if { \"$dir\" == \"in\"} {\n"
    "	set to [info namespace tail $to]\n"
    "	set log_name $to\n"
    "	if { \"$from\" == \"dd\" } {set type DD}\n"
    "    } else {\n"
    "	set from [info namespace tail $from]\n"
    "	set log_name $from\n"
    "	if { \"$to\" == \"dd\" } {set type DD}\n"
    "    }\n"
    "\n"
    "    set link_from $from\n"
    "    set link_to $to\n"
    "    constructor_C $session $from $to $dir $callback $host\n"
    "\n"
    "    if { \"$type\" == \"DD\" } {\n"
    "	dalogmsg \"INFO\" \"data link $from to $to (DD data link)\"\n"
    "    }\n"
    "    \n"
    "    \n"
    "    set port 0\n"
    "\n"
    "    if { \"$host\" == \"\" } {\n"
    "	set host [dp_hostname]\n"
    "    }\n"
    "\n"
    "    if { \"$dir\" == \"in\" } {\n"
    "	if {\"$type\" != \"DD\"} {\n"
    "\n"
    "\n"
    "	    if { \"$server\" == \"\" } {\n"
    "		if { \"$host\" != \"\"} {\n"
    "		    set rv [dp_connect -server 0 -host $host -reuseAddr]\n"
    "		} else {\n"
    "		    set rv [dp_connect -server 0 -reuseAddr]\n"
    "		}\n"
    "		set server [lindex $rv 0]\n"
    "		set port [lindex $rv 1]\n"
    "		dp_filehandler $server re \"itcl_context $this ::LINK AcceptLINKConnection\"\n"
    "		dp_atexit appendUnique \"close $server\"\n"
    "		dp_atclose $server append \"dp_shutdown $server both;dp_filehandler $server;catch {dp_atexit delete \\\"close $server\\\"};set server \\\"\\\"\"\n"
    "		dp_socketOption $server recvBuffer 252000\n"
    "		dp_socketOption $server autoClose yes\n"
    "		dp_socketOption $server nodelay 1\n"
    "		dp_socketOption $server keepAlive yes\n"
    "	    }\n"
    "	} else {\n"
    "	}\n"
    "	\n"
    "	global env\n"
    "	set name \"$from->$to\"\n"
    "	catch \"database set database $env(EXPID)\" res\n"
    "\n"
    "	catch \"database query \\\"create table links (name char(100) not null,type char(4) not null,host char(30),state char(10),port int)\\\"\" res\n"
    "	catch \"database query \\\"SELECT name FROM links WHERE name='$name'\\\" \" res\n"
    "	if [database get rows] {\n"
    "	    set res [database query \"UPDATE links SET host='$host',type='$type',port=$port,state='up' WHERE name='$name'\"]\n"
    "	} else {\n"
    "	    set res [database query \"INSERT INTO links (name,type,host,port,state) VALUES ('$name','$type','$host',$port,'up')\"]\n"
    "	}\n"
    "    } else {\n"
    "	if {\"$type\" != \"DD\"} {\n"
    "	    global env\n"
    "	    set name \"$from->$to\"\n"
    "	    catch \"database set database $env(EXPID)\" res\n"
    "	    catch \"database query \\\"create table links (name char(100) not null,type char(4) not null,host char(30),state char(10),port int)\\\"\" res\n"
    "	    catch \"database query \\\"SELECT port,host FROM links WHERE name='$name'\\\" \" res\n"
    "\n"
    "	    if [database get rows] {\n"
    "		set res [database get next]\n"
    "		set host [lindex $res 1]\n"
    "		set port [lindex $res 0]\n"
    "		set server [lindex [dp_connect $host $port] 0]\n"
    "		puts \"connect returns $server\"\n"
    "\n"
    "		set return [gets $server]\n"
    "		if {[lindex $return 1] == \"refused:\"} {\n"
    "		    close $server\n"
    "		    error $return;\n"
    "		}\n"
    "		dp_socketOption $server sendBuffer 48000\n"
    "		dp_socketOption $server noblock no\n"
    "		dp_socketOption $server autoClose yes\n"
    "		dp_socketOption $server keepAlive yes\n"
    "		dp_atexit appendUnique \"close $server\"\n"
    "		dp_atclose $server append \"puts \\\"server $this down close $server\\\";dp_filehandler $server;dp_atexit delete \\\"close $server\\\"\"\n"
    "		dalogmsg \"INFO\" \"connected to $to ($host, $port, $server)\"\n"
    "	    } else {\n"
    "		error \"server for link\\\" $name\\\" not running.\"\n"
    "	    }\n"
    "	    set link $server\n"
    "	} else {\n"
    "	}\n"
    "    }\n"
    "    set state \"up\"\n"
    "    database query \"UPDATE links SET state='up' WHERE name='$name'\"\n"
    "}\n"
    "\n"
    "body LINK::write {data} {\n"
    "    if [catch \"struct_write -unbuffered $server $data\" res] {\n"
    "	ShutdownLINK $server\n"
    "	error \"link $name shut down\"\n"
    "    }\n"
    "}\n"
    "\n"
    "body LINK::statistics {} {\n"
    "    puts \"Statistics for $this\"\n"
    "    puts \"FIFO\"\n"
    "    puts \"name      waiting  putting  deleting total full\"\n"
    "    puts \"----      -------  -------  -------- ------ ----\"\n"
    "    puts \"[fifo_stats]\"\n"
    "}\n"
    "\n"
    "body LINK::AcceptLINKConnection {status file} {\n"
    "    if {[string compare $status e] == 0} {\n"
    "	close $file;\n"
    "	return; \n"
    "    }\n"
    "    set connection [dp_accept $file]\n"
    "    set newFile [lindex $connection 0]\n"
    "    set inetAddr [lindex $connection 1]\n"
    "    dalogmsg \"INFO\" \"link $name connected as $newFile to $inetAddr\"\n"
    "    dp_atclose $newFile prepend \"itcl_context $this ::LINK ShutdownLINK $newFile\"\n"
    "    dp_atclose $file appendUnique \"itcl_context $this ::LINK ShutdownLINK $newFile\"\n"
    "    dp_atexit appendUnique \"close $newFile\"\n"
    "    dp_filehandler $newFile e \"itcl_context $this ::LINK ProcessData\"\n"
    "\n"
    "    dp_socketOption $server recvBuffer 252000\n"
    "    dp_socketOption $newFile autoClose yes\n"
    "    dp_socketOption $newFile keepAlive yes\n"
    "    dp_after 10 \"itcl_context $this ::LINK startThread $newFile\"\n"
    "\n"
    "    dp_socketOption $server nodelay 1\n"
    "    dp_socketOption $newFile nodelay 1\n"
    "    set link $newFile\n"
    "    puts $newFile \"Connection accepted\"\n"
    "    set state up\n"
    "    database query \"UPDATE links SET state='up' WHERE name='$name'\"\n"
    "}\n"
    "\n"
    "\n"
    "body LINK::ShutdownLINK {file} {\n"
    "    dalogmsg \"WARN\" \"removing link $this (socket $file)\"\n"
    "    database query \"UPDATE links SET state='down' WHERE name='$name'\"\n"
    "    set state down\n"
    "    catch \"dp_filehandler $file\"\n"
    "    dp_atexit delete \"close $file\"\n"
    "    catch \"dp_atclose $file clear\"\n"
    "    dp_atclose $server delete \"itcl_context $this ::LINK ShutdownLINK $file\"\n"
    "    set link \"\"\n"
    "}\n"
    " \n"
    "}\n"
    ;
/* End of Tcl code */
/* Init routine to drag this code into our program...*/
int LINK_class_Init (Tcl_Interp *interp)
{
    if (Tcl_Eval(interp,initCmd) != 0) {
    char *val;
    fprintf (stderr, "ERROR:\\n      %s\\n", interp->result);
    val = Tcl_GetVar(interp, "errorInfo", TCL_GLOBAL_ONLY);
    fprintf (stderr, "TclStack:\\n      %s\\n",val);
       return TCL_ERROR;
    }
    return TCL_OK;
}
/* End of C code */
