#include "da.h"
#include "rc.h"


#include "bosio.h"
#include "ddiofun.h"

#define TRUE 1
#define FALSE 0

#define TCL_PROC(name) int name (objClass object, Tcl_Interp *interp, int argc, char **argv)

typedef int (*IFUNCPTR) ();

typedef struct ERpriv *ERp;

typedef struct ERpriv {
  int fd;
  int buffer_count;
  int log_EvDumpLevel;
  char *output_type;
  char *output_file;
  unsigned int output_switch;
  void *mod_id;
  char *mod_name[30];
  int  record_length;
  int  split;
  char *filename;
  pthread_t write_thread;
  objClass object;
  IFUNCPTR write_proc;
  IFUNCPTR close_proc;
  IFUNCPTR open_proc;
  int splitnb;
  int nevents;
  int nlongs;
} ER_priv;

TCL_PROC(FPACK_open_file)
{
  ERp erp = (ERp) object->private;
  int  status;
  erp->nlongs = 0;
  erp->nevents = 0;
  erp->splitnb = 0;

  if (erp->filename) {
    ckfree(erp->filename);
  } 

  erp->filename= ckalloc(1000);

  sprintf(erp->filename, erp->output_file, object->runNumber,erp->splitnb);

  sprintf(erp->filename,"OPEN UNIT=11 FILE='%s' WRITE RECL=%d RAW SPLITMB=%d",
	  erp->output_file,
	  erp->record_length,
	  erp->split);

  if ( (status = FParm(erp->filename,&erp->fd)) !=0) {
	sprintf(erp->filename,"FParm status %d \n",status);
	fprintf(stderr,erp->filename);
	return TCL_ERROR;
  }

  return TCL_OK;
}

TCL_PROC(FPACK_close_file)
{
  ERp erp = (ERp) object->private;
  int stat;

  stat = ddFlush(erp->fd);

  if (stat != 0) {
    fprintf(stderr,"Error in ddFlush");
    return TCL_ERROR;
  }
  
  stat = bosClose(erp->fd);
  
  if (stat != 0) {
    fprintf(stderr,"Error in bosClose");
    return TCL_ERROR;
  }

  if (Tcl_VarEval(erp->object->interp,"close_callback ",erp->object->name,NULL) != TCL_OK) {
    printf("no close callback\n");
  }

  return TCL_OK;
}


int 
FPACK_write_event(ERp erp)
{
  struct fifo_entry fev;
  int stat1,stat2,err=FALSE;
  char tmp[2000];

  if (!ddu_attached()) {
    fprintf(stderr,"Not attached to DD system");
    return 0;
  }
  
  do {
    stat1=ddu_get_fev(&fev);
  if (stat1 == 0) {
    if (fev.len<11) {
      printf("Control event :  0x%8.8X  0x%8.8X  0x%8.8X  0x%8.8X\n"
	     ,fev.p2da[0],fev.p2da[1],fev.p2da[2],fev.p2da[3]);
    } else {
      dumplogrec(fev.p2da,erp->log_EvDumpLevel);
      stat1 = ddWrite(erp->fd,&fev);
    }

    erp->object->nlongs += fev.len>>2;
    erp->object->nevents++;
    erp->nevents++;
    erp->nlongs+= fev.len>>2;

    stat2 = ddu_put_fev(fev); /* we should put event back anyway */
    
    if (stat1 == EBIO_NEWFILEOPEN) {  
      if (Tcl_VarEval(erp->object->interp,"close_callback ",erp->object->name,NULL) != TCL_OK) {
	printf("no close callback\n");
      }

      erp->splitnb++;
      erp->nlongs = 0;
      erp->nevents = 0;

      ckfree(erp->filename);
      erp->filename = strdup(BIOS_FINAME);
      stat1 = 0;
    }			
    if (stat1!=0) {
      sprintf(tmp," error writing to FPACK file : %i",stat1);
      fprintf(stderr,tmp);
      err=TRUE;
    }
    if (stat2!=0) {
      sprintf(tmp," error in ddu_put_fev(fev) status = %i",stat2);
      fprintf(stderr,tmp);
      err=TRUE;
    }		
  } else {
    if (stat1!=11) {
      sprintf(tmp,"error in ddu_get_fev(&fev) status = %i",stat1);
      fprintf(stderr,tmp);
      err=TRUE;
    }
  }

  } while (stat1 == 0);

  if (fev.ctlw1 == 20) 
    return(0);
  else
    return(1);
}
