/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *	Test routines for CAMAC calls.
 *	
 * Author:  Chip Watson, CEBAF Data Acquisition Group
 *
 * Revision History:
 *   $Log: test.c,v $
 *   Revision 1.1.1.1  1996/08/21 19:18:46  heyes
 *   Imported sources
 *
*	  Revision 1.1  94/03/16  07:53:22  07:53:22  heyes (Graham Heyes)
*	  Initial revision
*	  
*	  Revision 1.1  94/03/15  11:47:26  11:47:26  heyes (Graham Heyes)
*	  Initial revision
*	  
 *	  Revision 1.1  1992/12/08  18:56:44  watson
 *	  Initial revision
 *
 */

#include "ca.h"

cread1(int ext)
{
  int d,q;
  cfsa(0,ext,&d,&q);
}

cread11(int ext)
{
  int d,q;
  cfsa(0,ext,&d,&q);
  cfsa(0,ext,&d,&q);
  cfsa(0,ext,&d,&q);
  cfsa(0,ext,&d,&q);
  cfsa(0,ext,&d,&q);
  cfsa(0,ext,&d,&q);
  cfsa(0,ext,&d,&q);
  cfsa(0,ext,&d,&q);
  cfsa(0,ext,&d,&q);
  cfsa(0,ext,&d,&q);
  cfsa(0,ext,&d,&q);
}

creads1(int ext)
{
  int d,q;
  cssa(0,ext,&d,&q);
}

creads11(int ext)
{
  int d,q;
  cssa(0,ext,&d,&q);
  cssa(0,ext,&d,&q);
  cssa(0,ext,&d,&q);
  cssa(0,ext,&d,&q);
  cssa(0,ext,&d,&q);
  cssa(0,ext,&d,&q);
  cssa(0,ext,&d,&q);
  cssa(0,ext,&d,&q);
  cssa(0,ext,&d,&q);
  cssa(0,ext,&d,&q);
  cssa(0,ext,&d,&q);
}

testberr()
{
  int ext,d,q;
  ccinit(0);
  cdreg(&ext,0,2,1,0);
  cfsa(0,ext,&d,&q);
  printf("data %x   q %x\n",d,q);
}

  int testma,testmb;
testm()
{
  KS2917_WHEN_RDY(testma=testmb;);
}
