C -----------------------------------------------------------------------------
C  Copyright (c) 1991,1992 Southeastern Universities Research Association,
C                          Continuous Electron Beam Accelerator Facility
C 
C  This software was developed under a United States Government license
C  described in the NOTICE file included as part of this distribution.
C 
C  CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
C  Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
C -----------------------------------------------------------------------------
C  
C  Description:
C 	Sample CAMAC program
C 	
C  Author:  Chip Watson, CEBAF Data Acquisition Group
C 
C  Revision History:
C    $Log: camac.f,v $
C    Revision 1.1.1.1  1996/08/21 19:18:46  heyes
C    Imported sources
C
C	  Revision 1.1  94/03/16  07:53:08  07:53:08  heyes (Graham Heyes)
C	  Initial revision
C	  
C	  Revision 1.1  94/03/15  11:47:08  11:47:08  heyes (Graham Heyes)
C	  Initial revision
C	  
C	  Revision 1.1  1992/06/05  20:24:04  watson
C	  Initial revision
C
C

      INTEGER*4 C,N,A,F,D,Q
      INTEGER*4 REG,JUNK(2)
      INTEGER*4 ISTAT

      CALL CAOPEN('DAFARM01',ISTAT)

      IF (ISTAT.NE.1) THEN
         TYPE *,'FAILED TO CONNECT TO SERVER'
         CALL EXIT(0)
      ENDIF

c     Initialize branch 0
      CALL CCINIT(0)

c     Define a register crate 1, slot 3, addr 0
      CALL CDREG(REG,1,3,0,JUNK)

c     Write a test pattern
      CALL CFSA(16,REG,123,Q)
      type *,'Q on write',q

c     Read back the pattern
      CALL CFSA(0,REG,D,Q)
      TYPE *,'Data = ',d,'  q = ',q
      if (d.ne.123) type *,' read or write error!'

      end
