#! /bin/sh
# the next line restarts using tclsh \
exec tclsh "$0" "$@"

set binaries  [lindex $argv 0]
set argvfiles [lrange $argv 1 end]

set env(WAITTIME) 1000

set genDirs {
    general xpm hlist
}

set env(TCL_LIBRARY) 	$env(TEST_TCL_LIBRARY)
set env(TK_LIBRARY) 	$env(TEST_TK_LIBRARY)
set env(ITCL_LIBRARY) 	$env(TEST_ITCL_LIBRARY)
set env(ITK_LIBRARY) 	$env(TEST_ITK_LIBRARY)

catch {
    unset env(TIX_DEBUG_INTERACTIVE)
}

set load(bin) ../../../tk4.1b1/unix/wish
set tk40(bin) ../../unix-tk4.0/tixwish
set tk41(bin) ../../unix-tk4.1/tixwish
set itcl(bin) ../../unix-itcl2.0/itixwish
set tk40(dir) [concat $genDirs]
set tk41(dir) [concat $genDirs]
set itcl(dir) [concat $genDirs itcl]
set load(dir) load

set errCount 0

foreach b $binaries {
    upvar #0 $b target

    puts "Testing target $b with executable $target(bin)"

    set PWD [pwd]
    if {$argvfiles == {}} {
	foreach dir $target(dir) {
	    puts "Entering directory $dir ..."
	    cd $dir
	    set files [exec cat files]
	    regsub -all [format %s \n] $files " " files

	    foreach f $files {
		puts "Testing file $dir/$f"
		exec $target(bin) $f $b >@ stdout 2>@ stderr
	    }
	    puts "Leaving directory $dir ..."
	    cd $PWD
	}
    } else {
	foreach f $argvfiles {
	    if [file isdir $f] {
		set dir $f
		puts "Entering directory $dir ..."
		cd $dir
		set files [exec cat files]
		regsub -all [format %s \n] $files " " files

		foreach f $files {
		    puts "Testing file $dir/$f"
		    exec $target(bin) $f $b >@ stdout 2>@ stderr
		}
		puts "Leaving directory $dir ..."
		cd $PWD
	    } else {
		set dir [file dirname $f]
		if {$dir != {}} {
		    puts "Entering directory $dir ..."
		    cd $dir
		    set f [file tail $f]
		}

		puts "Testing file $f"
		exec $target(bin) $f $b >@ stdout 2>@ stderr

		puts "Leaving directory $dir ..."
		cd $PWD
	    }
	}
    }
}


#----------------------------------------------------------------------
#
# Here is the reporting section
#
#----------------------------------------------------------------------
puts "$errCount errors discovered"
