'\" The definitions below are for supplemental macros used in Tix
'\" manual entries.
'\"
'\" .HS name section [date [version]]
'\"	Replacement for .TH in other man pages.  See below for valid
'\"	section names.
'\"
'\" .AP type name in/out [indent]
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS [type [name]]
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .VS
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
.\"
'\"	# Heading for Tix man pages
.de HS
.ds ^3 \\0
.if !"\\$3"" .ds ^3 \\$3
.if '\\$2'cmds'      .TH "\\$1" 1 "\\*(^3" "\\$4" "\\$5"
.if '\\$2'lib'       .TH "\\$1" 3 "\\*(^3" "\\$4" "\\$5"
.if '\\$2'ncmds'     .TH "\\$1" n "\\*(^3" "\\$4" "\\$5"
.if '\\$2'tcl'       .TH "\\$1" n "\\*(^3"  Tcl   "Tcl Built-In Commands"
.if '\\$2'tk'        .TH "\\$1" n "\\*(^3"  Tk    "Tk Commands"
.if '\\$2'tclc'      .TH "\\$1" 3 "\\*(^3"  Tcl   "Tcl Library Procedures"
.if '\\$2'tkc'       .TH "\\$1" 3 "\\*(^3"  Tk    "Tk Library Procedures"
.if '\\$2'tclcmds'   .TH "\\$1" 1 "\\*(^3"  Tcl    "Tcl Applications"
.if '\\$2'tkcmds'    .TH "\\$1" 1 "\\*(^3"  Tk    "Tk Applications"
.if '\\$2'tix'        .TH "\\$1" n "\\*(^3"  Tk    "Tix Commands"
.if '\\$2'tixcmds'    .TH "\\$1" 1 "\\*(^3"  Tk    "Tix Applications"
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'----------------------------------------------------------------------
.HS tixPopupMenu tix 4.0
.BS
'
'
'----------------------------------------------------------------------
.SH NAME
tixPopupMenu \- Create and manipulate tixPopupMenu widgets
'
'
'
'----------------------------------------------------------------------
.SH SYNOPSIS
\fBtixPopupMenu\fI \fIpathName ?\fIoptions\fR?
'
'
'----------------------------------------------------------------------
.PP
.SH SUPER-CLASS
The \fBtixPopupMenu\fR class is derived from the \fBTixShell\fR
class and inherits all the commands, options and subwidgets of its
super-class.
'
'----------------------------------------------------------------------
.SH "STANDARD OPTIONS"
'
The PopupMenu widget supports all the standard options of a frame widget.
See the \fBoptions(n)\fR manual entry for details on the standard options.
'
'
'----------------------------------------------------------------------
.SH "WIDGET-SPECIFIC OPTIONS"
'
'
'----------BEGIN
.LP
.nf
Name:		\fBstate\fR
Class:		\fBState\fR
Switch:		\fB\-state\fR
.fi
.IP
Must be either \fBdisabled\fR or \fBnormal\fR. The PopupMenu widget will not
pop up unless its \fB\-state\fR is set to \fBnormal\fR.
'----------END
'
'
'----------BEGIN
.LP
.nf
Name:		\fBtitle\fR
Class:		\fBTitle\fR
Switch:		\fB\-title\fR
.fi
.IP
Specifies a text string to display inside the \fBmenubutton\fR
subwidget, as the title of this PopupMenu.
'----------END
'
'----------------------------------------------------------------------
.SH SUBWIDGETS
'----------BEGIN
.LP
.nf
Name:		\fBmenu\fR
Class:		\fBMenu\fR
.fi
.IP
The menu subwidget.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBmenubutton\fR
Class:		\fBMenubutton\fR
.fi
.IP
The menubutton subwidget.
'----------END
'
.BE
'
'----------------------------------------------------------------------
.SH DESCRIPTION
'
.PP
'
The \fBtixPopupMenu\fR command creates a new window (given by the
\fIpathName\fR argument) and makes it into a PopupMenu widget.
Additional options, described above, may be specified on the command
line or in the option database to configure aspects of the
PopupMenu widget such as its cursor and relief.

The Tix PopupMenu widget can be used as a replacement of the
\fBtk_popup\fR command. The advantage of the Tix PopupMenu widget is
it requires less application code to manipulate. Also, it provides a
title for the popup menu, which is not available from \fBtk_popup\fR.
'
'----------------------------------------------------------------------
.SH WIDGET COMMANDS
.PP
'
The \fBtixPopupMenu\fR command creates a new Tcl command whose name is
the same as the path name of the PopupMenu widget's window.  This
command may be used to invoke various operations on the widget. It has
the following general form:
'
.DS C
'
\fIpathName option \fR?\fIarg arg ...\fR?
.PP
.DE
'
\fIPathName\fR is the name of the command, which is the same as the
PopupMenu widget's path name. \fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command. The following commands
are possible for PopupMenu widgets:
.TP
\fIpathName \fBbind \fIwidget \fR?\fIwidget ...\fR?
'
Binds this PopupMenu to one or more \fIwidgets\fR. The PopupMenu
will be activated when the user presses the right mouse button over
these \fIwidgets\fR.
'
.TP
\fIpathName \fBcget\fR \fIoption\fR
'
Returns the current value of the configuration option given by
\fIoption\fR. \fIOption\fR may have any of the values accepted by the
\fBtixPopupMenu\fR command.
'
.TP
'
\fIpathName \fBconfigure\fR ?\fIoption\fR? \fI?value option value ...\fR?
'
Query or modify the configuration options of the widget.  If no
\fIoption\fR is specified, returns a list describing all of the
available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s); in
this case the command returns an empty string.  \fIOption\fR may have
any of the values accepted by the \fBtixPopupMenu\fR command.
'
'
.TP
\fIpathName \fBpost \fIwidget x y\fR
'
Posts the PopupMenu inside the \fIwidget\fR at the coordinate
\fIx\fR,\fIy\fR.
'
'
.TP
\fIpathName \fBunbind \fIwidget \fR?\fIwidget ...\fR?
'
Cancels the PopupMenu's binding with the \fIwidget(s)\fR.
'
'
.TP
\fIpathName \fBsubwidget \fI name ?args?\fR 
'
When no options are given, this command returns the pathname of the
subwidget of the specified name.

When options are given, the widget command of the specified subwidget
will be called with these options.
'
'
'----------------------------------------------------------------------
'.SH BINDINGS
'.PP
'
'
'----------------------------------------------------------------------
.SH KEYWORDS
Tix(n)
