/******************************************************************************
*
* header file for use with General VME based  rols with CODA crl (version 2.0)
*   The trigger source for polling or interrupts is the TJNAF VME Trigger
*   Supervisor Register.
*
*                             DJA   July 1996
*
*******************************************************************************/
#ifndef __VME_ROL__
#define __VME_ROL__

static int VME_handlers,VMEflag;
static int VME_isAsync;
static unsigned long VME_prescale = 1;
static unsigned long VME_count = 0;

/* define various structures for use in accessing commonly
   used VME modules like the Trigger Supervisor, VME trigger interface
   Lecroy scalers etc...  */

#define VME_STD_SUP_ASC    	0x3f
#define VME_STD_SUP_PGM		0x3e
#define VME_STD_SUP_DAT		0x3d

#define VME_STD_USR_ASC	        0x3b
#define VME_STD_USR_PGM		0x3a
#define VME_STD_USR_DAT		0x39

#define VME_SHR_SUP_IO		0x2d
#define VME_SHR_USR_IO		0x29

#define VME_EXT_SUP_ASC	        0x0f
#define VME_EXT_SUP_PGM		0x0e
#define VME_EXT_SUP_DAT 	0x0d

#define VME_EXT_USR_ASC    	0x0b
#define VME_EXT_USR_PGM		0x0a
#define VME_EXT_USR_DAT		0x09

extern int sysBusToLocalAdrs(int space,long *localA,long **busA);

/*
struct vme_ts {
    unsigned long csr;       
    unsigned long trig;
    unsigned long roc;
    unsigned long sync;
    unsigned long test;
    unsigned long state;
    unsigned long blank_1;           
    unsigned long blank_2;           
    unsigned long prescale[8];
    unsigned long timer[5];
    unsigned long blank_3;           
    unsigned long blank_4;           
    unsigned long blank_5;           
    unsigned long sc_as;
    unsigned long scale_0a;
    unsigned long scale_1a;
    unsigned long blank_6;           
    unsigned long blank_7;          
    unsigned long scale_0b;
    unsigned long scale_1b;
  };
*/

volatile struct vme_ts {
    volatile unsigned long csr;       
    volatile unsigned long csr2;       
    volatile unsigned long trig;
    volatile unsigned long roc;
    volatile unsigned long sync;
    volatile unsigned long trigCount;
    volatile unsigned long trigData;
    volatile unsigned long lrocData;
    volatile unsigned long prescale[8];
    volatile unsigned long timer[5];
    volatile unsigned long intVec;
    volatile unsigned long rocBufStatus;
    volatile unsigned long lrocBufStatus;
    volatile unsigned long rocAckStatus;
    volatile unsigned long userData1;
    volatile unsigned long userData2;
    volatile unsigned long state;
    volatile unsigned long test;
    volatile unsigned long blank1;
    volatile unsigned long scalAssign;
    volatile unsigned long scalControl;
    volatile unsigned long scaler[18];
    volatile unsigned long scalEvent;
    volatile unsigned long scalLive1;
    volatile unsigned long scalLive2;
    volatile unsigned long id;
  } VME_TS;


struct vme_tir {
    unsigned short tir_csr;
    unsigned short tir_vec;
    unsigned short tir_dat;
    unsigned short tir_oport;
    unsigned short tir_iport;
  };


struct vme_dpm {
    long dpm_mem[32768];
    unsigned short dpm_addr;
    unsigned short dpm_mode;
  };

struct vme_scal {
    unsigned short reset;
    unsigned short blank1[7];
    unsigned short bim[8];
    unsigned short blank2[16];
    unsigned long preset[16];
    unsigned long scaler[16];
    unsigned short blank3[29];
    unsigned short id[3];
  };

volatile struct vme_ts  *ts;
struct vme_tir *tir[2];
struct vme_dpm *dpm;
struct vme_dpm *dpml;
struct vme_scal *vscal[32];
struct vme_scal *vlscal[32];

volatile unsigned long *tsmem;
unsigned long ts_memory[4096];
long *vme2_ir;

/* Include trigger support routines for TIR module */
#include "vme_triglib.h"

void VME_int_handler()
{
  theIntHandler(VME_handlers);                   /* Call our handler */
}

/* define CODA readout list specific routines/definitions */

#define VME_TEST  vmettest

#define VME_INIT { VME_handlers =0;VME_isAsync = 0;VMEflag = 0;}

#define VME_ASYNC(code,id)  {printf("Linking async VME trigger to id %d \n",id); \
			       VME_handlers = (id);VME_isAsync = 1;vmetriglink(code,VME_int_handler);}

#define VME_SYNC(code,id)   {printf("Linking sync VME trigger to id %d \n",id); \
			       VME_handlers = (id);VME_isAsync = 0;}

#define VME_SETA(code) VMEflag = code;

#define VME_SETS(code) VMEflag = code;

#define VME_ENA(code,val)   vmetenable(code,val);

#define VME_DIS(code,val)   vmetdisable(code,val);

#define VME_ACK(code,val)   vmetack(code,val);

#define VME_CLRS(code) VMEflag = 0;

#define VME_GETID(code) VME_handlers

#define VME_TTYPE vmettype

#define VME_START(val)	 {;}

#define VME_STOP(val)	 {;}

#define VME_ENCODE(code) (code)


#endif

