/****************************************************************
*
* header file for use of Struck sfi with CODA crl (version 2.0)
*
*                             DJA   March 1996
*
*****************************************************************/
#ifndef __SFI__
#define __SFI__

/* Global variable to hold the source mask and an array to hold 
   valid trigger sources */
unsigned long sfiTrigSource;
unsigned long sfiAuxPort;

/* Global variable to hold the SFI Base address and OFFSET of 
   the local CPU memory as seen by the SFI VME Master. This 
   offset is gotten by a call to sysBusToLocalAdrs() */
unsigned long sfi_vme_base_address, sfi_cpu_mem_offset;

#include "sfi.h"
#include "sfi_fb_macros.h"
#include "sfi_triglib.h"

/* define CODA readout list specific routines/definitions */
static int padr, sadr;
static int SFI_handlers,SFIflag;
static unsigned long SFI_isAsync;

#define SFI_REPORT_ERROR  sfi_error_decode(0)

static inline void 
fpbr(int pa, long len) 
{
  unsigned long bufp, rb, lenb;
  int res;

/* Make maximum len(lw) equal to 1/4 minus header of Max event length */
 if (len <= 0) len = (MAX_EVENT_LENGTH>>4) - 2;
 bufp = (unsigned long) (rol->dabufp) + sfi_cpu_mem_offset;
 lenb = (len<<2);

 if (pa >= 0) {
   res = fb_frdb_1(pa,0,bufp,lenb,&rb,1,0,1,0,0x0a,0,0,1);
 } else {
   res = fb_frdb_1(0,0,bufp,lenb,&rb,1,1,1,0,0x0a,1,1,1);
 }

 if ((rb > (lenb+4))||(res != 0)) {
   *rol->dabufp++ = 0xfb000bad;
   logMsg("fpbr error pa=%d res=0x%x maxBytes=%d retBytes=%d fifo=0x%x\n",pa,res,lenb,rb,sfiSeq2VmeFifoVal,0);
   sfi_error_decode(0x3);
 }else{
   rol->dabufp += (rb>>2);
 }

 return;   
 fooy:
  SFI_REPORT_ERROR;
  return;
}

static inline void 
fpbr2(int pa, int sa, long len) 
{
  unsigned long bufp, rb, lenb;
  int res;

/* Make maximum len(lw) equal to 1/4 minus header of Max event length */
 if (len <= 0) len = (MAX_EVENT_LENGTH>>4) - 2;
 bufp = (unsigned long) (rol->dabufp) + sfi_cpu_mem_offset;
 lenb = (len<<2);

 if (pa >= 0) {
   if (sa > 0) {
     res = fb_frdb_1(pa,sa,bufp,lenb,&rb,1,0,0,0,0x0a,0,0,1);
   }else{
     res = fb_frdb_1(pa,0,bufp,lenb,&rb,1,0,1,0,0x0a,0,0,1);
   }
 } else {
     res = fb_frdb_1(0,0,bufp,lenb,&rb,1,1,1,0,0x0a,1,1,1);
 }

 if ((rb > (lenb+4))||(res != 0)) {
   *rol->dabufp++ = 0xfb000bad;
   logMsg("fpbr error pa=%d res=0x%x maxBytes=%d retBytes=%d \n",pa,res,lenb,rb,0,0);
   sfi_error_decode(0x3);
 }else{
   rol->dabufp += (rb>>2);
 }

 return;   
 fooy:
  SFI_REPORT_ERROR;
  return;
}

static inline void 
fpbrf(int pa, long len) 
{
  unsigned long bufp, rb, lenb;
  int res;

/* Make maximum len(lw) equal to 1/4 minus header of Max event length */
  if (len <= 0) len = (MAX_EVENT_LENGTH>>4) - 2;
  lenb = (len<<2);
/* Check for 8 byte boundary for address */
  if( ( (unsigned long) (rol->dabufp)&0x7) ) {
    *rol->dabufp++ = 0xdaffffff;
    bufp = (unsigned long) (rol->dabufp) + sfi_cpu_mem_offset;
  } else {
    bufp = (unsigned long) (rol->dabufp) + sfi_cpu_mem_offset;
  }

  if (pa >= 0) {
    res = fb_frdb_1(pa,0,bufp,lenb,&rb,1,0,1,0,0x08,0,0,1);
  } else {
    res = fb_frdb_1(0,0,bufp,lenb,&rb,1,1,1,0,0x08,1,1,1);
  }

  if ((rb > (lenb+4))||(res != 0)) {
    *rol->dabufp++ = 0xfb000bad;
    logMsg("fpbrf error pa = %d res = 0x%x maxbytes = %d returnBytes = %d \n",pa,res,lenb,rb);
    sfi_error_decode(0x3);
  }else{
    rol->dabufp += (rb>>2);
  }

  return;   
 fooy:
  SFI_REPORT_ERROR;
  return;
}

static inline void 
fpbrf2(int pa, int sa, long len) 
{
  unsigned long bufp, rb, lenb;
  int res;

/* Make maximum len(lw) equal to 1/4 minus header of Max event length */
  if (len <= 0) len = (MAX_EVENT_LENGTH>>4) - 2;
  lenb = (len<<2);
/* Check for 8 byte boundary for address */
  if( ( (unsigned long) (rol->dabufp)&0x7) ) {
    *rol->dabufp++ = 0xdaffffff;
    bufp = (unsigned long) (rol->dabufp) + sfi_cpu_mem_offset;
  } else {
    bufp = (unsigned long) (rol->dabufp) + sfi_cpu_mem_offset;
  }

  if (pa >= 0) {
    if (sa > 0) {
      res = fb_frdb_1(pa,sa,bufp,lenb,&rb,1,0,0,0,0x08,0,0,1);
    }else{
      res = fb_frdb_1(pa,0,bufp,lenb,&rb,1,0,1,0,0x08,0,0,1);
    }
  } else {
    res = fb_frdb_1(0,0,bufp,lenb,&rb,1,1,1,0,0x08,1,1,1);
  }

  if ((rb > (lenb+4))||(res != 0)) {
    *rol->dabufp++ = 0xfb000bad;
    logMsg("fpbrf error pa = %d res = 0x%x maxbytes = %d returnBytes = %d \n",pa,res,lenb,rb);
    sfi_error_decode(0x3);
  }else{
    rol->dabufp += (rb>>2);
  }

  return;   
 fooy:
  SFI_REPORT_ERROR;
  return;
}


void 
SFI_int_handler()
{
/* Clear inturrupt source */
  *sfi.VmeIrqMaskReg  = (sfiTrigSource<<8);      /* Clear VME Source */

#ifdef VXWORKSPPC
/*  sysBusIntAck(5); */
#endif
 

  theIntHandler(SFI_handlers);                   /* Call our handler */
}


#define SFI_TEST  sfittest

#define SFI_INIT { SFI_handlers =0;SFI_isAsync = 0;SFIflag = 0;}

#define SFI_ASYNC(code,id) {printf("linking async SFI trigger to id %d \n",id); \
			       SFI_handlers = (id);SFI_isAsync = 1;sfitriglink(code,SFI_int_handler);}

#define SFI_SYNC(code,id)  {printf("linking sync SFI trigger to id %d \n",id); \
			      SFI_handlers = (id);SFI_isAsync = 0;}

#define SFI_SETA(code) {theIntHandler(SFI_handlers);}

#define SFI_SETS(code) SFIflag = code;

#define SFI_ENA(code,val) sfitenable(code,val);

#define SFI_DIS(code,val) sfitdisable(code,val);

#define SFI_ACK(code,val) sfitack(code,val);

#define SFI_CLRS(code) SFIflag = 0;

#define SFI_GETID(code) SFI_handlers

#define SFI_TTYPE sfittype

#define SFI_START(val)	 {;}

#define SFI_STOP(val)	 {;}

#define SFI_ENCODE(code) code


#endif

