/* 
 *
 *   Dual CPU Header file
 *
 */

#define DCPU_MEM_SIZE   2*1024*1024   /* 2 Meg */

/* If defined then DMA is used for CPU to CPU data transfer */
#undef  DCPU_USE_DMA

/* Define Base Address of PRPMC memory as seen from VME Base board (Source) */
#define PCI_SOURCE_MEM_OFFSET    0xc0000000
#define PCI_SOURCE_MEM_SIZE      0x20000000

/* Define Base Address of VME CPU as seen from PRPMC (destination) */
/*  PRPMC 880 */
#define PCI_DEST_MEM_OFFSET      0xc0000000
#define PCI_DEST_MEM_SIZE        0x20000000


/* PRPMC 880 - MV5500 */
/*
#define PCI_DEST_MEM_OFFSET      0x83000000
#define PCI_DEST_MEM_SIZE        0x20000000
*/


/* dualCPU Init ID */
#define DC_INIT_SRC_ID    0xda00ad00
#define DC_INIT_DEST_ID   0xda01ad01


/* Keep this 16 byte aligned for CPU to CPU transfer purposes */
typedef struct dcpu_control
{
  volatile unsigned int          full;                /* Buffer Full flag*/
  volatile unsigned int          clear;               /* clear */
  volatile unsigned int          nevents;             /* Total Number of events */
  volatile unsigned int         *local;               /* Local Memory Address*/
  volatile unsigned int          csr;	              /* DAQ command/state  register*/
  volatile unsigned int          first;               /* first event number in memory */
  volatile unsigned int          last;                /* last event in memory */
  volatile unsigned int          user[4];             /* Array for user control data */
  volatile unsigned int          nwords;              /* number of words in memory */
  volatile unsigned int          data[1];	      /* event data - start on 16 byte boundary */
} DCPU_CONTROL;



/* Commands */
#define DC_CMD_MASK    0xffff
#define DC_DOWNLOAD       0x1
#define DC_PRESTART       0x2
#define DC_GO             0x4
#define DC_END            0x8

/* States */
#define DC_STATE_MASK  0xffff0000
#define DC_DOWNLOADED     0x10000
#define DC_PRESTARTED     0x20000
#define DC_ACTIVE         0x40000
#define DC_ENDING         0xc0000
#define DC_ENDED          0x80000
#define DC_ERROR       0xff000000
#define DC_IDLE             0

/* Prototypes */
void dcpuGetTest();
void dcpuSendDownload();
void dcpuSendPrestart();
void dcpuSendGo();
void dcpuSendEnd();
