# Boot file for CODA ROC 2.5 
# with DUAL CPU Support - PRPMC (Destination) Board
# PowerPC version


# Load host table
hostAdd "mizar","129.57.14.33"
hostAdd "mizar.jlab.org","129.57.14.33"
hostAdd "alcor","129.57.14.30"
hostAdd "alcor.jlab.org","129.57.14.30"


# Setup environment / load coda_roc
putenv "MSQL_TCP_HOST=mizar"
putenv "EXPID=experiment_0"
putenv "TCL_LIBRARY=/usr/local/coda/2.5/common/lib/tcl7.4"
putenv "ITCL_LIBRARY=/usr/local/coda/2.5/common/lib/itcl2.0"
putenv "DP_LIBRARY=/usr/local/coda/2.5/common/lib/dp"
putenv "CMLOG_PORT=8103"
putenv "CMLOG_HOST=alcor"  
putenv "TOKEN_PORT=5555"
putenv "SESSION=davetest"


# Download Message logging libraries/client
ld < /group/da/CMLOG/CMLOG-R2_1-PROD-1/bin/ppc-vw55/cmlogClientD
ld < /group/da/CMLOG/CMLOG-R2_1-PROD-1/lib/ppc-vw55/libcmlog.a
ld < /group/da/CMLOG/CMLOG-R2_1-PROD-1/bin/ppc-vw55/cmlogVxLogMsg


cd "/usr/local/coda/2.5/VXWORKSPPC/bin"
ld < coda_roc

# Load dual cpu library and Init as Destination CPU
cd "/mizar/home/abbottd/vxWorks/dualCPU"
ld<dcpuLib.o
sp dcpuInit,1


# Spawn tasks
sp cmlogClientD
#sp cmlogVxLogMsg
taskDelay (60*5)
taskSpawn ("ROC",200,8,250000,coda_roc,"","-s","davetest","-objects","ROC1 ROC")


