.\"**********************************************************************
.\"*									*
.\"*	Copyright 1993 by Motorola Wireless Data Group,			*
.\"*			  Bothell, WA					*
.\"*									*
.\"*	Motorola hereby grants permission to use, copy, modify and	*
.\"*	distribute  this software and its documentation for any		*
.\"*	purpose and without fee, provided that you retain this		*
.\"*	copyright notice in all copies.  Motorola makes no		*
.\"*	representations about the suitability of this software for any	*
.\"*	purpose.  Motorola provides this software ``as is'' without	*
.\"*	express or implied warranty.					*
.\"*									*
.\"**********************************************************************
.\"
.\" $Header: /mizar/local/source/coda_source/Tcl/src7.4/svipc/man/linkvar.n,v 1.1.1.1 1996/08/21 19:30:10 heyes Exp $
.\"
.TH "linkvar" TCL "" "Tcl"
.SH NAME
linkvar unlinkvar - Associate memory location with Tcl variable

.SH SYNOPSIS
.nf
\fBlinkvar \fI?-rdonly? varName addr type ?elements?\fR

\fBunlinkvar \fIvarName\fR
.fi

.SH DESCRIPTION
These commands associate memory locations with Tcl variables.  Read
access to the Tcl variable returns the current value stored in the
assocaited memory location, and writing to the Tcl variable modifies
the corresponding memory location.  These commands access a modified
version of the Tcl_LinkVar(3) function called Svipc_LinkVar(3).
.PP
The \fBlinkvar\fR command places a variable trace on the Tcl variable
named by \fIvarName\fR.  It basically passes all of the arguments on
the the \fISvipc_LinkVar(3)\fR procedure.  The optional argument
\fI-rdonly\fR specifies read-only access to the traced address and
disallows write operations on the traced variable.  \fIaddr\fR
specifies the virtual memory address to associate with the variable
trace, \fItype\fR specifies the type of the variable, and
\fIelements\fR specifies the number of consecutive memroy elements to
include in the trace.
.PP
The \fItype\fR argument specifies the type of value traced at the
given memory location, and must have one of the following values:
.IP \fIint\fR 1i
Trace standard signed \fBint\fR values.
.IP \fIboolean\fR 1i
Trace standard \fIint\fR-sized true or false values.
.IP \fIdouble\fR 1i
Trace standard \fIdouble\fR values.
.IP \fIstring\fR 1i
Trace dynamic Tcl strings.  \fIaddr\fR specifies a \fIchar *\fR value
which receives the address of a dynamically-allocated Tcl string.  The
procedure allocates a new string every time you write to the variable.
This type ignores any setting of \fIelements\fR.
.IP \fIchar\fR 1i
Trace standard \fIsigned char\fR values.
.IP \fIuchar\fR 1i
Trace standard \fIunsigned char\fR values.
.IP \fIshort\fR 1i
Trace standard \fIsigned short\fR values.
.IP \fIushort\fR 1i
Trace standard \fIunsigned short\fR values.
.IP \fIstaticstr\fR 1i
Trace static character strings.  In this case, \fIelements\fR
specifies the size of the character array.  Reads of the traced
variable return the results of \fIstrncpy()\fR applied to the
addressed character array, and writes of the traced variable fill the
character array using \fImemcpy()\fR.

The \fBunlinkvar\fR command removes any variable traces previously set by
the \fBlinkvar\fR command for \fIvarName\fR.

.SH SEE ALSO
Svipc_LinkVar(3), Svipc_UnlinkVar(3), Svipc_LinkVarWritable(3)

.SH AUTHOR
.nf
Joe Kelsey
Motorola Wireless Data Group
19807 NorthCreek Parkway N.
Bothell, WA  98011
206.489.5746
kelsey@mdd.comm.mot.com
