'\" The definitions below are for supplemental macros used in Tix
'\" manual entries.
'\"
'\" .HS name section [date [version]]
'\"	Replacement for .TH in other man pages.  See below for valid
'\"	section names.
'\"
'\" .AP type name in/out [indent]
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS [type [name]]
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .VS
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
.\"
'\"	# Heading for Tix man pages
.de HS
.ds ^3 \\0
.if !"\\$3"" .ds ^3 \\$3
.if '\\$2'cmds'      .TH "\\$1" 1 "\\*(^3" "\\$4" "\\$5"
.if '\\$2'lib'       .TH "\\$1" 3 "\\*(^3" "\\$4" "\\$5"
.if '\\$2'ncmds'     .TH "\\$1" n "\\*(^3" "\\$4" "\\$5"
.if '\\$2'tcl'       .TH "\\$1" n "\\*(^3"  Tcl   "Tcl Built-In Commands"
.if '\\$2'tk'        .TH "\\$1" n "\\*(^3"  Tk    "Tk Commands"
.if '\\$2'tclc'      .TH "\\$1" 3 "\\*(^3"  Tcl   "Tcl Library Procedures"
.if '\\$2'tkc'       .TH "\\$1" 3 "\\*(^3"  Tk    "Tk Library Procedures"
.if '\\$2'tclcmds'   .TH "\\$1" 1 "\\*(^3"  Tcl    "Tcl Applications"
.if '\\$2'tkcmds'    .TH "\\$1" 1 "\\*(^3"  Tk    "Tk Applications"
.if '\\$2'tix'        .TH "\\$1" n "\\*(^3"  Tk    "Tix Commands"
.if '\\$2'tixcmds'    .TH "\\$1" 1 "\\*(^3"  Tk    "Tix Applications"
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'----------------------------------------------------------------------
.HS tixScrolledListBox tix 4.0
.BS
'
'
'----------------------------------------------------------------------
.SH NAME
tixScrolledListBox \- Create and manipulate Tix ScrolledListBox widgets
'
'
'
'----------------------------------------------------------------------
.SH SYNOPSIS
\fBtixScrolledListBox\fI \fIpathName ?\fIoptions\fR?
'
'
'
'----------------------------------------------------------------------
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fB
'
anchor	background	cursor
relief	borderWidth
'
\fR
.ta 4c 
.fi
.LP
See the \fBoptions(n)\fR manual entry for details on the standard options.
'
'
'----------------------------------------------------------------------
.SH "WIDGET-SPECIFIC OPTIONS"
'----------BEGIN
.LP
.nf
Name:		\fBanchor\fR
Class:		\fBAnchor\fR
Switch:		\fB\-anchor\fR
.fi
.IP
Specifies the alignment of the items inside the listbox subwidget.
Only the values \fBw\fR and \fBe\fR are allowed. When set to \fBw\fR,
the listbox is automatically aligned to the beginning of the items.
When set to \fBe\fR, the listbox is automatically aligned to the end
of the items.  Automatically alignment only happens when the
ScrolledListBox widget changes its size.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBbrowsecmd\fR
Class:		\fBBrowseCmd\fR
Switch:		\fB\-browsecmd\fR
.fi
.IP
Specifies the command to be called when the user browses the elements
inside the \fBlistbox\fR subwidget (see the BINDINGS section below).
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBcommand\fR
Class:		\fBCommand\fR
Switch:		\fB\-command\fR
.fi
.IP
Specifies the command to be called when the user invokes the \fBlistbox\fR
subwidget (see the BINDINGS section below).
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBheight\fR
Class:		\fBHeight\fR
Switch:		\fB\-height\fR
.fi
.IP
Specifies the desired height for the window, in pixels.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBscrollbar\fR
Class:		\fBScrollbar\fR
Switch:		\fB\-scrollbar\fR
.fi
.IP
Specifies the display policy of the scrollbars. The following
values are recognized:
.RS
'
.TP
\fBauto\fR \fR?\fI\+x\fR? \fR?\fI\-x\fR? \fR?\fI\+y\fR? \fR?\fI\-y\fR? 
'
When \fB\-scrollbar\fR is set to "\fBauto\fR", the scrollbars are
shown only when needed. Additional modifiers can be used to force a
scrollbar to be shown or hidden. For example, "\fBauto \-y\fR" means
the horizontal scrollbar should be shown when needed but the vertical
scrollbar should always be hidden; "\fBauto +x\fR" means the vertical
scrollbar should be shown when needed but the horizontal scrollbar
should always be shown, and so on.
'
.TP
\fBboth\fR
Both scrollbars are shown
'
.TP
\fBnone\fR
The scrollbars are never shown.
'
.TP
\fBx\fR
Only the horizontal scrollbar is shown;
'
.TP
\fBy\fR
Only the vertical scrollbar is shown.
'
.RE
'
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBwidth\fR
Class:		\fBWidth\fR
Switch:		\fB-width\fR
.fi
.IP
Specifies the desired width for the window, in pixels.
'----------END
'
'----------------------------------------------------------------------
.SH SUBWIDGETS
'
'----------BEGIN
.LP
.nf
Name:		\fBhsb\fR
Class:		\fBScrollbar\fR
.fi
.IP
The horizontal scrollbar subwidget.
'----------END
'
'
'----------BEGIN
.LP
.nf
Name:		\fBlistbox\fR
Class:		\fBListbox\fR
.fi
.IP
The listbox subwidget inside the ScrolledListBox widget.
'----------END
'
'----------BEGIN
.LP
.nf
Name:		\fBvsb\fR
Class:		\fBScrollbar\fR
.fi
.IP
The vertical scrollbar subwidget.
'----------END
'
.BE
'
'
'----------------------------------------------------------------------
.SH DESCRIPTION
'
.PP
'
The \fBtixScrolledListBox\fR command creates a new window (given by the
\fIpathName\fR argument) and makes it into a ScrolledListBox widget.
Additional options, described above, may be specified on the command
line or in the option database to configure aspects of the
ScrolledListBox widget such as its cursor and relief.
'
'----------------------------------------------------------------------
.SH WIDGET COMMANDS
.PP
'
The \fBtixScrolledListBox\fR command creates a new Tcl command whose
name is the same as the path name of the ScrolledListBox widget's
window. This command may be used to invoke various operations on the
widget. It has the following general form:
'
.DS C
'
\fIpathName option \fR?\fIarg arg ...\fR?

.DE
'
\fIPathName\fR is the name of the command, which is the same as the
ScrolledListBox widget's path name. \fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following commands
are possible for ScrolledListBox widgets:
'
.TP
'
\fIpathName \fBcget\fR \fIoption\fR
'
Returns the current value of the configuration option given by
\fIoption\fR. \fIOption\fR may have any of the values accepted by the
\fBtixScrolledListBox\fR command.
'
.TP
'
\fIpathName \fBconfigure\fR ?\fIoption\fR? \fI?value option value ...\fR?
'
Query or modify the configuration options of the widget.  If
no \fIoption\fR is specified, returns a list describing all of the
available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s); in
this case the command returns an empty string.  \fIOption\fR may have
any of the values accepted by the \fBtixScrolledListBox\fR command.
'
.TP
'
\fIpathName \fBsubwidget \fI name ?args?\fR 
'
When no additional arguments are given, returns the pathname of the
subwidget of the specified name.

When no additional arguments are given, the widget command of the
specified subwidget will be called with these parameters.
'
'----------------------------------------------------------------------
'
.SH BINDINGS
.PP
.IP [1]
'
If the \fB\-browsecmd\fR option is set, the command which it referes
to is called whenever a <ButtonPress\-1> or a <Motion\-1> event occurrs
inside the \fBlistbox\fR subwidget.
'
.PP
.IP [2]
'
If the \fB\-selectmode\fR option of the \fBlistbox\fR subwidget is
\fBbrowse\fR, the command specified by the \fB\-command\fR option is
invoked when a <ButtonRelease\-1> event occurrs inside the
\fBlistbox\fR subwidget. If the \fB\-selectmode\fR option of the
\fBlistbox\fR subwidget is \fBsingle\fR, \fBmultiple\fR or
\fBextended\fR, the command specified by the \fB\-command\fR option is
invoked when a <Double\-1> event occurrs inside the \fBlistbox\fR
subwidget.
'
'----------------------------------------------------------------------
'
.SH BUGS
'
The capitalization of some of the commands names in Tix 3.x has been
changed in Tix 4.0. All commands that ended with \fBbox\fR have been
changed to a capitalized \fBBox\fR. Hence, the command
\fBtixScrolledListbox\fR in Tix 3.x has been changed to
\fBtixScrolledListBox\fR in Tix 4.0
'
'
'----------------------------------------------------------------------
.SH KEYWORDS
Tix(n)
