/*

File:		fb_types.h
=====

Author:		Jim Pangburn
=======		CDF on-line computing
		Fermilab MS 318
		P.O. Box 500
		Batavia, IL  60510
		(708) 840-2207

	e-mail: "pangburn@fnal.fnal.gov"

Creation date:	
==============

Revision history:-
=================



Description:-
============

	Header file defining types used by the FASTBUS standard routines
	for C.

Include files:-
==============

#include "vxTypes.h"

Macros:-
=======
*/

#ifndef INCfbtypes
#define INCfbtypes

#define FB_TRUE                 1
#define FB_FALSE                0
#define FB_TRUE_READ_ONLY       0x10000001
#define FB_FALSE_READ_ONLY      0x10000000

#define FBSEQ			1
#define FB_BUFFER_SEQ		FBSEQ
#define FBVAR			2
#define FB_BUFFER_VAR		FBVAR
#define FBVAL			3
#define FB_BUFFER_VALUE		FBVAL

typedef int			FB_boolean;
typedef unsigned long		FB_buffer_mode;
typedef unsigned long		FB_error_code;
typedef int			FB_integer;
typedef unsigned long		FB_line;
typedef	int			FB_list_pointer;
typedef unsigned long		FB_operator;
typedef	unsigned long	       	FB_parameter_id;
typedef unsigned long		FB_parameter_value;
typedef unsigned long		FB_port_id;
typedef unsigned long		FB_response_code;
typedef FUNCPTR			FB_routine;
typedef unsigned long		FB_seq_buffer_id;
typedef int			FB_severity;
typedef	unsigned long		FB_word;
typedef char			*FB_string;
typedef FB_word			*array_of_FB_word;

#define FB_SEV_SUCCESS		1
#define FB_SEV_INFO		3
#define FB_SEV_WARNING		2
#define FB_SEV_ERROR		4
#define FB_SEV_FATAL		4
#define FB_SEV_NEVER		5

#define FSSUCC			FB_SEV_SUCCESS
#define FSINFO			FB_SEV_INFO
#define FSWARN			FB_SEV_WARNING
#define FSERR			FB_SEV_ERROR
#define FSFTL			FB_SEV_FATAL
#define FSNEV			FB_SEV_NEVER

/************************************************************************/
/* Retcod representation in 32 Bits					*/
/*									*/
/*	Facility Code     Error Code Severity				*/
/*	FFFFFFFFFFFFFFFFFFEEEEEEEEEEESSS				*/
/*	|               |              |				*/
/* Bits 31              15             0				*/
/*									*/
#define FB_SEVERITY_SHIFT	3		/* errorcode severity shift */
#define FB_SEVERITY_BITS	0x00000007	/* errorcode severity mask */
#define FB_FACILITY_BITS	0xffffc000	/* errorcode facility mask */
#define FB_ERROR_BITS		0x00003fff	/* errorcode err/sev mask */


#endif 	/* (ifndef INCtypes) */
