#ifndef time
#include <sys/time.h>
#endif

/* Definition of a TIME trigger source */

static int TIME_handlers[32],TIMEflag;
static int TIME_periods[32];
static int TIME_when[32];
static time_t TIME_now[32];
static unsigned char TIME_isAsync[32];

static int TIME_doTIME(int code)
{
  return(TIMEflag);			/* always true */
}


static int TIME_TEST (int code){
  time_t localTime;
  int stat = 0;
  if (TIMEflag == 0) return(0);
  if (TIME_periods[code] == 0) return(1);
  localTime = time(0) - TIME_now[code];
  if (localTime>0) {
    TIME_now[code] = time(0);
    if (TIME_periods[code] && TIME_handlers[code]) {
      TIME_when[code] -= localTime;
      if (TIME_when[code] <= 0) {
	TIME_when[code] = TIME_periods[code];
	stat = 1;
      }
    }
  }
  return(stat);
}

#define TIME_INIT { bzero((char *) TIME_handlers, sizeof(TIME_handlers));bzero((char *) TIME_isAsync, sizeof(TIME_isAsync));}

#define TIME_ASYNC(code,id) {printf("linking code %d to id %d\n",code,id); \
			       TIME_handlers[code] = (id);TIME_isAsync[code] = 1;}

#define TIME_SYNC(code,id) {printf("linking code %d to id %d\n",code,id); \
			      TIME_handlers[code] = (id);TIME_isAsync[code] = 0;TIME_now[code] = time(0);}

#define TIME_SETA(code) {theIntHandler(TIME_handlers[code]);}

#define TIME_SETS(code) TIMEflag = code;

#define TIME_ENA(code,val) TIME_periods[code] = val;TIME_when[code] = val;

#define TIME_DIS(code) TIME_periods[code] = 0;

#define TIME_CLRS(code) TIMEflag = 0;

#define TIME_GETID(code) TIME_handlers[code]

#define TIME_START(val)	 {TIMEflag = 1;}

#define TIME_STOP(val)	 {alarm(0);TIMEflag = 0;}

#define TIME_ENCODE(code) code

#define TIME_TIME  TIME_doTIME

/* End  TIME trigger source */

