#!/usr/bin/perl -w

#  xml2codadb.pl

#  loads coda configuration into database from xml file
#  creates 4 tables per config and updates runTypes and process tables

#  still to to:


#  E.Wolin, Jefferson Lab, 9-sep-2003



use XML::Parser;
use DBI;
    

#  Perl code:
#  ----------

#  defaults
$dbtype   = "mSQL";
$account  = "wolin";
$password = undef;
$ignore   = 0;
$debug    = 0;
$help     = "\n  Usage:\n         xml2codadb [-t dbtype] [-a account] [-p password] dbname filename [config1 config2...]\n\n";


# decode command line args
$line=join(" ",@ARGV);
if($line =~ s/-h//i) { die $help;}
($dbtype   =  $1) if ($line =~ s/-t\s+(\S*)//i);
($account  =  $1) if ($line =~ s/-a\s+(\S*)//i);
($password =  $1) if ($line =~ s/-p\s+(\S*)//i);
($debug    =   1) if ($line =~ s/-debug//i);


# get dbname, filename, and config names
($dbname=$1,$filename=$2) if ($line=~s/^\s*(\S+)\s+(\S+)//);
if(!defined $dbname   || ($dbname     =~/^\s*$/)) {die $help;}
if(!defined $filename || ($filename   =~/^\s*$/)) {die $help;}

$confignames=$line;
if($confignames=~/^\s*$/) {undef $confignames}


#  get connection
($conn=DBI->connect("DBI:$dbtype:dbname=$dbname;",$account,$password,
		    {PrintError=>1,AutoCommit=>1})) 
    || die "Failed to connect to database $dbname\n";


#  get existing config id's from runTypes table
$h=$conn->prepare("select name,id from runTypes");
$h->execute;
while(@row=$h->fetchrow_array) {
    $cfgid{trim($row[0])}=$row[1];
    $cfgidlist{$row[1]}="t";
    if($debug!=0) {print "@row\n";}
}
$h->finish;


#  get existing ROC, EB, and ER component id's from process table
$h=$conn->prepare("select name,id,type from process");
$h->execute;
while(@row=$h->fetchrow_array) {
    if(($row[2] eq "ROC")||($row[2] eq "EB")||($row[2] eq "ER")) {
	$compid{trim($row[0])}=$row[1];
	$compidlist{$row[1]}="t";
	if($debug!=0) {print "@row\n";}
    }
}
$h->finish;


#  parse file, update database
$parser = new XML::Parser(ErrorContext => 2);
$parser->setHandlers(
		     Start   => \&start_handler,
		     End     => \&end_handler
		     );
$parser->parsefile($filename);


#  done
$conn->disconnect;
exit;


#-------------------------------------------------------------------------


#  start tag handler
sub start_handler {
    my $p      = shift(@_);
    my $tag    = shift(@_);
    my %atts   = @_;


    if($ignore!=0) {return;}


    if($tag eq "config") {
	$config=trim($atts{name});
	
	#  if list defined is config in list?
	if(defined $confignames && !($confignames=~/\b$config\b/)) {
	    print "...ignoring $config\n";
	    $ignore=1;
	    return;
	}


	#  drop tables or get new config id
	if(defined $cfgid{$config}) {
	    if($debug!=0) {print "dropping $config\n";}
	    $conn->do("drop table $config");
	    $conn->do("drop table ${config}_pos");
	    $conn->do("drop table ${config}_script");
	    $conn->do("drop table ${config}_option");
	} else {
	    $i=0;
	    while(1) {
		if(!(defined $cfgidlist{$i})) {
		    $cfgid{$config}=$i;
		    $cfgidlist{$i}="t";
		    last;
		}
		$i++;
	    }
	    $sql="insert into runTypes (name,id,inuse,category) values (".
		"\'$config\',$cfgid{$config},\'no\',\'\')";
	    $conn->do($sql);
	}


        # create tables
	print "...installing config $config\n";
	$conn->do("CREATE TABLE $config (name CHAR(32) NOT NULL PRIMARY KEY,code CHAR(512) NOT NULL,".
		  "inputs CHAR(400) NOT NULL,outputs CHAR(400) NOT NULL,first CHAR(32) NOT NULL,".
		  "next CHAR(32) NOT NULL,inuse CHAR(32) NOT NULL)");
	$conn->do("CREATE TABLE ${config}_pos (name CHAR(32) NOT NULL PRIMARY KEY,".
		  "row INT NOT NULL,col INT NOT NULL)");
	$conn->do("CREATE TABLE ${config}_option (name CHAR(32) NOT NULL,value CHAR(80) NOT NULL)");
	$conn->do("CREATE TABLE ${config}_script (name CHAR(32) NOT NULL,state CHAR(32) NOT NULL,".
		  "script CHAR(128) NOT NULL)");



    } elsif ($tag eq "component") {
	$comp=trim($atts{name});
	
	#  make entry in config table
	$atts{code}=trim($atts{code});
	$atts{inputs}=trim($atts{inputs});
	$atts{outputs}=trim($atts{outputs});
	$atts{first}=trim($atts{first});
	$atts{next}=trim($atts{next});
	$sql="insert into $config (name,code,inputs,outputs,first,next,inuse) values (".
	    "\'$comp\',\'$atts{code}\',\'$atts{inputs}\',\'$atts{outputs}\',".
	    "\'$atts{first}\',\'$atts{next}\',\'no\')";
	$conn->do($sql);


	#  get component id and update process table
	$conn->do("delete from process where name=\'$comp\'");
	$atts{type}=trim($atts{type});
	if(!($atts{type}=~/^\s*$/)) {
	    if(defined $compid{$comp}) {
		$id=$compid{$comp};
	    } elsif(($atts{type} eq "ROC")||($atts{type} eq "EB")||($atts{type} eq "ER")) {
		if($atts{type} eq "ROC") {$i=0;} else {$i=50;}
		while(1) {
		    if(!(defined $compidlist{$i})) {
			$id=$i;
			$compid{$comp}=$i;
			$compidlist{$i}="t";
			last;
		    }
		    $i++;
		}
	    } else {
		$id=-1;
	    }
	    if($atts{type} eq "EB") {
		$cmd="\$CODA_BIN/coda_eb";
	    } elsif ($atts{type} eq "ER") {
		$cmd="\$CODA_BIN/coda_er";
	    } else {
		$cmd="none";
	    }
	    $conn->do("insert into process (name,id,cmd,type,host,port,state,pid,inuse,clone) values ".
		      "(\'$comp\',$id,\'$cmd\',\' $atts{type}\',\' \',0,".
		      "\'down\',0,\'no\',\'no\')");
	}
	    

    } elsif ($tag eq "pos") {
	$atts{name}=trim($atts{name});
	$atts{row}=trim($atts{row});
	$atts{col}=trim($atts{col});
	$sql="insert into ${config}_pos (name,row,col) values (".
	    "\'$atts{name}\',$atts{row},$atts{col})";
	$conn->do($sql);


    } elsif ($tag eq "script") {
	$atts{name}=trim($atts{name});
	$atts{state}=trim($atts{state});
	$atts{script}=trim($atts{script});
	$sql="insert into ${config}_script (name,state,script) values (".
	    "\'$atts{name}\',\'$atts{state}\',\'$atts{script}\')";
	$conn->do($sql);


    } elsif ($tag eq "option") {
	$atts{name}=trim($atts{name});
	$atts{value}=trim($atts{value});
	$sql="insert into ${config}_option (name,value) values (".
	    "\'$atts{name}\',\'$atts{value}\')";
	$conn->do($sql);
    }

}


#-------------------------------------------------------------------------


sub end_handler {
    my $p      = shift(@_);
    my $tag    = shift(@_);

    if($tag eq "config") {
	$ignore=0;
    }

}


#-------------------------------------------------------------------------


sub trim {
    my @out = @_;

    for (@out) {
	s/^\s+//;
	s/\s+$//;
    }

    return wantarray ? @out : $out[0];

}


#-------------------------------------------------------------------------
