//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      cdevService Error Handler Class
//
// Author:  Jie Chen
//
// Revision History:
//   cdevErrSvc.cc,v
// Revision 1.1.1.1  1995/06/16  17:14:07  epics
// initial import of cdev
//
//
#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <cdevErrCode.h>
#include "cdevErrSvc.h"

cdevErrSvc::cdevErrSvc (cdevSystem& system)
:cdevService ((char *)"cdev_Error_Service", system)
{
#ifdef _TRACE_OBJECTS
  printf("    Create cdevErrSvc class\n");
#endif
  // don't register this service to service list
  // User should not access this service
  // Parent class already register itselef
  system.removeService (this);
}

cdevErrSvc::~cdevErrSvc (void)
{
#ifdef _TRACE_OBJECTS
  printf("    Delete cdevErrSvc class\n");
#endif
}

int
cdevErrSvc::getFd (int* &fd, int& numFd)
{
  numFd = 0;
  fd = 0;
  return CDEV_INVALIDSVC;
}

int
cdevErrSvc::flush (void)
{
  return CDEV_INVALIDSVC;
}

int
cdevErrSvc::poll (void)
{
  return CDEV_INVALIDSVC;
}

int
cdevErrSvc::pend (int )
{
  return CDEV_INVALIDSVC;
}

int
cdevErrSvc::pend (double, int)
{
  return CDEV_INVALIDSVC;
}

int
cdevErrSvc::getRequestObject (char *, char *, cdevRequestObject* &reqObj)
{
  reqObj = 0;
  return CDEV_INVALIDSVC;
}

int
cdevErrSvc::getNameServer (cdevDevice* &ns)
{
  ns = 0;
  return CDEV_INVALIDSVC;
}
