//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      CDEV Configuration Loader for different site
//
// Author:  Jie Chen
//
// Revision History:
//   cdevConfigFinder.cc,v
// Revision 1.2  1997/09/18  18:12:50  chen
// check site configuration file before loading
//
// Revision 1.1  1997/08/27  18:23:30  chen
// Change error reporting to site specific scheme
//
//
//
#include "cdevConfigFinder.h"

#ifdef SHOBJ
#include <shObjLoader.h>
#include <sys/stat.h>

#ifndef _WIN32
#include <unistd.h>
#endif

int cdevConfigFinder::tloadconfig_ = 0;

cdevConfigFinder::cdevConfigFinder (cdevSystem& system)
:loader_ (0), system_ (system)
{
#ifdef _TRACE_OBJECTS
  printf ("Create cdevConfigFinder Class Object\n");
#endif
}

cdevConfigFinder::~cdevConfigFinder (void)
{
#ifdef _TRACE_OBJECTS
  printf ("Delete cdevConfigFinder Class Object\n");
#endif
  if (loader_)
    delete loader_;
}

int
cdevConfigFinder::loadConfig (void)
{
  if (!cdevConfigFinder::tloadconfig_) {
    int status = -1;
    int (*create)(cdevSystem *);
  
    char  location[3][256];
    char *envVar = ::getenv ("CDEVSHOBJ");
	
    *location[0] = '\0';
    *location[1] = '\0';
    *location[2] = '\0';
    
    // assign flag
    cdevConfigFinder::tloadconfig_ = 1;

    if(envVar!= NULL && *envVar) {
      // *************************************************************
      // * The first search location is in the versioned directory
      // * under the cdev shared object directory... this would look
      // * like... "/usr/cdev/shobj/1.3/filename.so"
      // *************************************************************
      sprintf(location[0], 
	      "%s/%s.%s/%s", 
	      envVar, 
	      cdevSystem::CDEV_MAJOR_VERSION,
	      cdevSystem::CDEV_MINOR_VERSION,
	      _CDEV_CONFIG_FILENAME);
      // *************************************************************
      // * The second search location is within the cdev shared object
      // * directory... this would look like... 
      // * "/usr/cdev/shobj/filename.so"
      // *************************************************************
      sprintf(location[1], 
	      "%s/%s", 
	      envVar, 
	      _CDEV_CONFIG_FILENAME);
    }
    // *********************************************************************
    // * The third search location is within the /usr/local/lib directory...
    // * This would look like... "/usr/local/lib/filename.so"
    // *********************************************************************
    sprintf(location[2], "/usr/local/lib/%s", _CDEV_CONFIG_FILENAME);
    
    // *********************************************************************
    // * Walk through the list of possible locations until the shared 
    // * library is successfully loaded, or until all options have been
    // * exhausted.
    // *********************************************************************
    struct stat sbuf;
    for(int i = 0; i < 3; i++) {
      if (*location[i] != '\0') {

	// find out whether this file is there
	if (stat (location[i], &sbuf) != 0) 
	  continue;


	loader_ = new shObjLoader (location[i]);
	if( loader_->load () == 0) {
	  if (loader_->findProcedureSym (_CDEV_CONFIG_ROUTINE, 
					(void **)&create) == 0) {
	    status = (*create)(&system_);
	    break;
	  }
	  else {
	    delete loader_;
	    loader_ = 0;
	  }
	}
	else {
	  delete loader_;
	  loader_ = 0;
	}
      }
    }
    return status;
  }
  else
    return 0;
}

#else
#include "cdevConfigFinder.h"

cdevConfigFinder::cdevConfigFinder (cdevSystem &)
{
  // empty
}

#endif


  
  
