#ifndef _CDEV_DEVICE_DEFINITION_H_
#define _CDEV_DEVICE_DEFINITION_H_

#ifndef _CDEV_DIRECTORY_TABLE_H_
	#error "You must include cdevDirectoryTable.h to load cdevDeviceDefinition.h"
#endif

// *****************************************************************************
// * class cdevDeviceDefinition :
// *	This class stores information that identifies a specific device name
// *	and associates it with a class.
// * 
// *	This class maintains a variety of internal data items for the following
// *	purposes...
// *
// *	name      - This is the name of the device as specified in the DDL file.
// *	directory - This is the cdevDirectoryTable object where the device was
// *                registered.
// *	cdevClass - This is the definition object for the class that the device
// *                belongs to.
// *	next      - This is the next device in the linked list of cdevDevice
// *                Definition objects.  This list is maintained as part of the
// *                cdevClassDefinition object.
// *****************************************************************************
class cdevDeviceDefinition 
{
private:
	char                       * name;
	char                       * substName;
	class cdevDirectoryTable   & directory;
	class cdevClassDefinition  & cdevClass;
	cdevDeviceDefinition       * next;
		
public:
	inline  cdevDeviceDefinition ( cdevDirectoryTable  & Directory,
				       char                * Name, 
				       char                * SubstName,
				       cdevClassDefinition & CdevClass );		
	inline ~cdevDeviceDefinition ( void );

	// *********************************************************************
	// * Member access methods.
	// *********************************************************************
	inline char                 * getName           ( void );
	inline char                 * getSubstituteName ( void );
	inline cdevDirectoryTable   & getDirectory      ( void );
	inline cdevClassDefinition  & getClass          ( void );
	inline cdevDeviceDefinition * getNext           ( void );
	inline void                   setNext           ( cdevDeviceDefinition * Next );
};


// *****************************************************************************
// * cdevDeviceDefinition::cdevDeviceDefinition :
// *	This is the constructor for the cdevDeviceDefinition class.
// *****************************************************************************
inline cdevDeviceDefinition::cdevDeviceDefinition 
	( cdevDirectoryTable  & Directory,
	  char                * Name,
	  char                * SubstName, 
	  cdevClassDefinition & CdevClass )
	: directory(Directory), next(NULL), name(Name), 
	  substName(SubstName), cdevClass(CdevClass)
	{
	}
		
// *****************************************************************************
// * cdevDeviceDefinition::~cdevDeviceDefinition :
// *	This is the destructor for the cdevDeviceDefinition class.
// *****************************************************************************
inline cdevDeviceDefinition::~cdevDeviceDefinition ( void )
	{
	if(name)      free(name);
	if(substName) delete substName;
	}


// *****************************************************************************
// * cdevDeviceDefinition::getName :
// *	This method allows the caller to retrieve the device name.
// *****************************************************************************
inline char * cdevDeviceDefinition::getName ( void ) 
	{
	return name;
	}

// *****************************************************************************
// * cdevDeviceDefinition::getSubstituteName :
// *	This method allows the caller to retrieve the device name.
// *****************************************************************************
inline char * cdevDeviceDefinition::getSubstituteName ( void ) 
	{
	return substName==NULL?name:substName;
	}

// *****************************************************************************
// * cdevDeviceDefinition::getDirectory :
// *	This method allows the caller to retrieve the directory object that
// *	owns this device.
// *****************************************************************************
inline cdevDirectoryTable & cdevDeviceDefinition::getDirectory ( void )
	{
	return directory;
	}
	
// *****************************************************************************
// * cdevDeviceDefinition::getClass :
// *	This method allows the caller to retrieve the class object that
// *	owns this device.
// *****************************************************************************
inline cdevClassDefinition & cdevDeviceDefinition::getClass ( void )
	{
	return cdevClass;
	}
	
// *****************************************************************************
// * cdevDeviceDefinition::getNext :
// *	This method allows the caller to retrieve the next device in the list.
// *****************************************************************************
inline cdevDeviceDefinition * cdevDeviceDefinition::getNext ( void )
	{
	return next;
	}

// *****************************************************************************
// * cdevDeviceDefinition::setNext :
// *	This method allows the caller to set the next device in the list.
// *****************************************************************************
inline void cdevDeviceDefinition::setNext ( cdevDeviceDefinition * Next )
	{
	next = Next;
	}

#endif
