//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      cdevTimerHandler Class
//
//      This class is a base class for handling timer based event.
//      Derived classes implement the real function.
//
// Author:  Jie Chen
//
// Revision History:
//   cdevTimerHandler.h,v
// Revision 1.1  1998/02/10  18:04:57  chen
// add cdevSystem timer handler
//
//
//
#ifndef _CDEV_TIMER_HANDLER_H
#define _CDEV_TIMER_HANDLER_H

#include <cdevTimeValue.h>

class cdevTimerHandler
{
public:
  // constructor
  cdevTimerHandler          (void) {}
  // destructor
  virtual ~cdevTimerHandler (void) {}

  virtual int timerCallback (double /* time */,
			     const void* /* arg */ = 0) {return 0;}
  // PURPOSE: this function is called when timer is expired
  // REQUIRE: none
  // PROMISE: if return -1: all timers associated with this handler
  //          will be removed. return 0: everything is ok.

  virtual const char* className (void) const {return "cdevTimerHandler";}

private:
  // deny access to copy and assignment operator
  cdevTimerHandler (const cdevTimerHandler& handler);
  cdevTimerHandler& operator = (const cdevTimerHandler& handler);

};
#endif
