//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      Some useful functions for caService and caRequestObject
//
// Author:  Jie Chen
//
// Revision History:
//   caMisc.cc,v
// Revision 1.4  1995/11/10  20:07:32  chen
// Relax restriction on data matching
//
// Revision 1.3  1995/07/14  11:49:42  akers
// Modifications to support the new cdevData class
//
// Revision 1.2  1995/06/29  18:51:26  akers
// Updated cdevData Type
//
// Revision 1.1.1.1  1995/06/16  17:14:02  epics
// initial import of cdev
//
//
#include "caService.h"
#include "caMisc.h"
#include <cdevErrCode.h>

int
dataMatch (cdevData& data, int type, int count)
{
  int dtype;
  int dim = 0, len = 0;
  int status = CDEV_SUCCESS;
  dtype = data.getType (caService::CA_TAG_VALUE);
  switch (type){
  case DBR_STRING:
    if (dtype != CDEV_STRING)
      status = CDEV_ERROR;
    break;
  case DBR_ENUM: // user will use string
    if (dtype != CDEV_STRING)
      status = CDEV_ERROR;
    break;
  case DBR_SHORT: // allow cdevData to do conversion
  case DBR_LONG:
  case DBR_FLOAT:
  case DBR_DOUBLE:
    break;
  default:
    status = CDEV_ERROR;
    break;
  }
  if (status == CDEV_SUCCESS){
    int st = data.getDim (caService::CA_TAG_VALUE, (size_t *)&dim);
    if (count == 1) {
      if (dim != 0)
	return CDEV_ERROR;
    }
    else {
      if (dim != 1)
	return CDEV_ERROR;

      // ***********************************************************************
      // * cdevBounds support added for support of arbitrary dimensional data
      // ***********************************************************************
      cdevBounds bounds;
      st = data.getBounds (caService::CA_TAG_VALUE, &bounds, 1);
      len = bounds.length;
      
      if (len != count)
	status = CDEV_ERROR;
    }
  }
  return status;
}
