//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      cdev Transaction Object class (for service developer only)
//
// Author:  Jie Chen
//
// Revision History:
//   cdevTranObj.h,v
// Revision 1.4  1996/05/02  14:17:44  chen
// handle unfinished transaction
//
// Revision 1.3  1995/12/08  15:35:57  chen
// handle deferred mode
//
// Revision 1.2  1995/10/03  19:34:52  chen
// disable/enable deleting callback
//
// Revision 1.1.1.1  1995/06/16  17:14:07  epics
// initial import of cdev
//
//
#ifndef _CDEV_TRANOBJ_H
#define _CDEV_TRANOBJ_H

#include <stdio.h>
#include <assert.h>
#include <cdevSpec.h>
#include <cdevSystem.h>
#include <cdevData.h>
#include <cdevCallback.h>

class cdevGroup;
class cdevRequestObject;

class CDEV_CLASS_SPEC cdevTranObj
{
public:
  // constructors and destructor
  cdevTranObj  (void);
  cdevTranObj  (cdevSystem        *sys,
		cdevRequestObject *reqObj, 
		cdevData          *data, 
		cdevCallback      *callback);
  ~cdevTranObj (void);

  int status (void) const;
  // PURPOSE: return status of transaction object
  // REQUIRE: nothing
  // PROMISE: -1: not registered into any group, 1: registered into groups

  int operator == (const cdevTranObj& rsc);
  int operator != (const cdevTranObj& rsc);
  // PURPOSE: equality operator
  // REQUIRE: nothing
  // PROMISE: obvious
  
  int removeFromGrps (void);
  // PURPOSE: remove this transaction object from all groups
  // REQUIRE: nothing
  // PROMISE: status = -1

  void disableDeleteCbk (void);
  void enableDeleteCbk  (void);
  // PURPOSE: enable/disable delete callback flag
  // REQUIRE: nothing
  // PROMISE: you know

  void trash     (cdevGroup* grp);
  int  isTrash   (void) const;
  // PURPOSE: throw this transaction object into a trash dump
  // REQUIRE: nothing;
  // PROMISE: this transaction object will not attempt to call any callback
  //          function

  // data area for requestObject to access
  cdevSystem        *system_;
  cdevRequestObject *reqObj_;
  cdevData          *resultData_;
  cdevCallback      *userCallback_;
  int               status_;
  cdevGroup         *activeGroups_[MAX_NUM_GROUPS];
  int               numGroups_;
  // pointer entries to all active groups
  cdevTranObj       **entryPtr_[MAX_NUM_GROUPS];

  const char *className (void) const {return "cdevTranObj";}

private:
  // deny copy and assignment operation
  // It makes no sense for two identical transaction objects
  cdevTranObj  (const cdevTranObj& rsc);
  cdevTranObj& operator = (const cdevTranObj& rsc);

  // flag of deleting callback or not.
  // Reason: callback may need stay after the transaction object goes away
  int               deleteCallback_;

  // flag of garbage transaction object (do not care any callbacks)
  int               trash_;

  // friend class 
  friend class cdevGroup;
};
#endif
