#ifndef _CDEV_REDIRECTOR_DEFINITION_H_
#define _CDEV_REDIRECTOR_DEFINITION_H_

#ifndef _CDEV_DIRECTORY_TABLE_H_
	#error "You must include cdevDirectoryTable.h to load cdevRedirectorDefinition.h"
#endif

#include <stdio.h>

// *****************************************************************************
// * class cdevRedirectorDefinition :
// *	This class is used to store the information that identifies the
// *	service and service data that is associated with a specific message.
// *	This class is only instanciated in a cdevClassDefinition that has 
// *	been instanciated.
// *
// *	To reduce the number of copies of extraneous data, this class will
// *	use the service data that is stored in the cdevElementDefinition.
// *****************************************************************************
class cdevRedirectorDefinition 
{
private:
	char                  * name;
	cdevServiceDefinition * service;
	char                 ** serviceData;
	int                     nItems;	

public:
	inline cdevRedirectorDefinition  ( char *Name, cdevElementDefinition &def);
	inline ~cdevRedirectorDefinition ( void );
	inline void asciiDump            ( FILE * fp = stdout );

	// *********************************************************************
	// * Member access methods
	// *********************************************************************
	inline char                  * getName        ( void );
	inline cdevServiceDefinition * getService     ( void );
	inline       char           ** getServiceData ( void );
	inline int                     getDataCnt     ( void );
};	


// *****************************************************************************
// * cdevRedirectorDefinition::cdevRedirectorDefinition :
// *	This is the constructor for the cdevRedirectorDefinition class... The
// *	message parameter becomes the property of the class and should not
// *	be accessed again by the caller...
// *****************************************************************************
inline cdevRedirectorDefinition::cdevRedirectorDefinition  
	( char *Name, cdevElementDefinition &def)
	: name       (Name),
	  service    (def.getService()),
	  serviceData(def.getServiceData()),
	  nItems     (def.getDataCnt())
	{
	}
	
	
// *****************************************************************************
// * cdevRedirectorDefinition::~cdevRedirectorDefinition :
// *	This is the destructor for the cdevRedirectorDefinition object.
// *****************************************************************************
inline cdevRedirectorDefinition::~cdevRedirectorDefinition ( void )
	{
	delete[] name;
	}


// *****************************************************************************
// * cdevRedirectorDefinition::asciiDump :
// *	This is a diagnostic method that allows the caller to dump the contents
// *	of the class redirection table that identifies which service will
// *	be used for each message.
// *****************************************************************************
inline void cdevRedirectorDefinition::asciiDump ( FILE * fp )
	{
	fprintf(fp, "\t\t\"%s\" %s", name, service->getName());
	if(serviceData!=NULL && nItems>0)
		{
		fprintf(fp, " {");
		for(int i=0; i<nItems; i++)
			{
			if(i<nItems-1) fprintf(fp, " %s,", serviceData[i]);
			else           fprintf(fp, " %s }", serviceData[i]);
			}
		}
	fprintf(fp, "\n");
	}

// *****************************************************************************
// * cdevRedirectorDefinition::getName :
// * 	Allows the caller to retrieve the name of the message within the object.
// *****************************************************************************
inline char * cdevRedirectorDefinition::getName ( void )
	{
	return name;
	}

// *****************************************************************************
// * cdevRedirectorDefinition::getService :
// * 	Allows the caller to retrieve the service associated with the message.
// *****************************************************************************
inline cdevServiceDefinition * cdevRedirectorDefinition::getService ( void )
	{
	return service;
	}

// *****************************************************************************
// * cdevRedirectorDefinition::getServiceData :
// * 	Allows the caller to retrieve the service data associated with the 
// *	messages.
// *****************************************************************************
inline       char ** cdevRedirectorDefinition::getServiceData ( void )
	{
	return serviceData;
	}

// *****************************************************************************
// * cdevRedirectorDefinition::getDataCnt :
// * 	Allows the caller to retrieve the number of entries in the service data.
// *****************************************************************************
inline int cdevRedirectorDefinition::getDataCnt ( void )
	{
	return nItems;
	}

#endif /* _CDEV_REDIRECTOR_DEFINITION_H_ */
