/* -----------------------------------------------------------------------------
 *  Copyright (c) 1995,1996 Southeastern Universities Research Association,
 *                          Continuous Electron Beam Accelerator Facility
 * 
 *  This software was developed under a United States Government license
 *  described in the NOTICE file included as part of this distribution.
 * 
 * -----------------------------------------------------------------------------
 * 
 *  Description:
 *       Class implementing request objects for collections
 * 
 *  Author:  Walt Akers
 * 
 *  Revision History:
 *    cdevCollectionRequest.h,v
 * Revision 1.1  1996/11/12  20:32:18  akers
 * New collection device source code
 *
 * -----------------------------------------------------------------------------
 */ 
#ifndef _CDEV_COLLECTION_REQUEST_H
#define _CDEV_COLLECTION_REQUEST_H

#include <cdevSystem.h>
#include <cdevRequestObject.h>
#include <cdevCollection.h>

// *****************************************************************************
// * cdevCollectionRequest:
// *	This is the cdevCollectionRequest class.  It is the master type for
// *	all service derived cdevCollectionRequest objects.  
// *****************************************************************************
class CDEV_CLASS_SPEC cdevCollectionRequest: public cdevRequestObject
{
friend class cdevCollection;
friend class cdevGrpCollectionRequest;

public:
	// *********************************************************************
	// * Returns the name of the class.
	// *********************************************************************
	const char *className (void) const {return "cdevCollectionRequest";}

	// *********************************************************************
	// * Returns the RESULT_CODE_TAG identifier.
	// *********************************************************************
	static int resultCodeTag(void) { return RESULT_CODE_TAG; }

protected:
	// *********************************************************************
	// * Constructor and destructor for the class.
	// *********************************************************************
	cdevCollectionRequest  (char **devices, int nDevices, char *msg, cdevSystem& sys);
	virtual ~cdevCollectionRequest (void);

	// *********************************************************************
	// * Factory used to generate cdevCollectionRequest objects.
	// *********************************************************************
	static cdevCollectionRequest * attachPtr(cdevCollection &device,  char *msg, cdevSystem &system);
	
	// *********************************************************************
	// * This is the integer that wil be used to store the cdevData tag that 
	// * will contain the completion code.
	// *********************************************************************
	static int RESULT_CODE_TAG;
};

#endif
