.SUFFIXES: .cc .obj

APPNAME        = Client/Server Performance Test
ARCH           = WINNT-4.0
SHOBJ          = YES

BINARIES = $(BASEBIN)\PerformanceServer.exe \
		   $(BASEBIN)\PerformanceTest.exe \
           $(CDEVLIB)\PerformanceService.dll \
           $(CDEVLIB)\PerformanceService.lib 

include ..\..\include\makeinclude\Makefile.WINNT-4.0

CXXINCLUDES    = /I .\\  /D "MANUAL=TRUE"
CXXEXTRA_DLL   = /D "PERFORMANCE_SERVICE_API=__declspec(dllexport)"
CXXEXTRA_LIB   = /D "PERFORMANCE_SERVICE_API="

!IF "$(SHOBJ)" == "YES"
TARGETS  = $(BASEBIN)\PerformanceServer.exe \
		   $(BASEBIN)\PerformanceTest.exe \
           $(CDEVLIB)\PerformanceService.dll 
!ELSE
TARGETS  = $(BASEBIN)\PerformanceServer.exe \
		   $(BASEBIN)\PerformanceTest.exe \
           $(CDEVLIB)\PerformanceService.lib 
!ENDIF

targets : $(TARGETS)
		
$(CDEVLIB)\PerformanceService.dll : $(OBJDIR)\PerformanceService.obj
	@echo ^ ^ ^ =^> Linking $(@F) 
	-@if exist $@ erase $@
	-@if not exist $(@D) mkdir $(@D)
	@$(LIB32) $(CDEVLIB)\cdev.lib $(CDEVLIB)\cdevGenericServer.lib\
	$(LINK_DLL_FLAGS) /out:$@ /implib:$(@D)\$(@B).lib $?
	-@copy $@ $(CDEVSHOBJ)\$(CDEVVERSION)\$(@F) > nul
	@echo ^ ^ ^ ^ ^ ^ Done...
	
$(CDEVLIB)\PerformanceService.lib : $(OBJDIR)\PerformanceService.obj
	@echo ^ ^ ^ =^> Linking $(@F) 
	-@if exist $@ erase $@
	-@if not exist $(@D) mkdir $(@D)
	@$(LIB32) $(CDEVLIB)\cdev.lib $(CDEVLIB)\cdevGenericServer.lib\
	$(LINK_LIB_FLAGS) /out:$@ $?
	@echo ^ ^ ^ ^ ^ ^ Done...

$(BASEBIN)\PerformanceServer.exe : .exec\$(TARGETDIR)\PerformanceServer.obj 
	-@if exist $@ erase $@
	@echo ^ ^ ^ ^ ^ ^ =^> Linking $(@F)
	$(LINK) $(CDEVLIB)\cdev.lib $(CDEVLIB)\cdevGenericServer.lib \
	$(LINK_EXE_FLAGS) /out:$@ $?
	@echo ^ ^ ^ ^ ^ ^ ^ ^ ^ Done...

$(BASEBIN)\PerformanceTest.exe : .exec\$(TARGETDIR)\PerformanceTest.obj
	-@if exist $@ erase $@
	@echo ^ ^ ^ ^ ^ ^ =^> Linking $(@F)
	$(LINK) $(CDEVLIB)\cdev.lib $(CDEVLIB)\cdevGenericServer.lib \
	$(LINK_EXE_FLAGS) /out:$@ $?
	@echo ^ ^ ^ ^ ^ ^ ^ ^ ^ Done...
