#include <cdevPlatforms.h>
#include <cdevSystem.h>
#include <cdevRequestObject.h>
#include <cdevDevice.h>
#include <cdevGroup.h>
#include <cdevCommon.h>

int callbackCount = 0;

void callback ( int status, void * /*arg*/, cdevRequestObject & req, cdevData & /*data*/ )
	{
	if(status==CDEV_SUCCESS)
		{
		callbackCount++;
		if(callbackCount%1==0) fprintf(stdout, "Received callback %i - %s:%s \n", callbackCount, req.device().name(), req.message());
		}
	else if(status==CDEV_DISCONNECTED) fprintf(stdout, "The monitor has become disconnected on %s:%s\n", req.device().name(), req.message());
	else if(status==CDEV_RECONNECTED) fprintf(stdout, "The monitor has become reconnected on %s:%s\n", req.device().name(), req.message());
	else fprintf(stdout, "Status code %i was received on %s:%s\n", status, req.device().name(), req.message());
	fflush(stdout);
	}
	
const int DEVICE_COUNT  = 9;
const int MESSAGE_COUNT = 9;

int main (  )
	{
	cdevRequestObject & monOnReq = cdevRequestObject::attachRef("ExpSrv", "monitorOn attrib1");
	cdevRequestObject & monOffReq = cdevRequestObject::attachRef("ExpSrv", "monitorOff attrib1");
	cdevCallback cb (callback, NULL);
	monOnReq.sendCallback(NULL, cb);
	while(callbackCount<10)
		{
		cdevSystem::defaultSystem().pend(1.0);
		}
	monOffReq.sendCallback(NULL, cb);
	fprintf(stdout, "Kill me when you're tired of looking at this...\n");
	fflush(stdout);
	while(1) cdevSystem::defaultSystem().pend(1.0);
	
	return 0;
	}
