#include <cdevPlatforms.h>
#include <cdevSystem.h>
#include <cdevRequestObject.h>
#include <cdevDevice.h>
#include <cdevGroup.h>
#include <cdevCommon.h>

int main ( )
	{
	fprintf(stdout, "\n\
=> **********************************************************************\n\
=> * This is the program is used to test what happens when a default    *\n\
=> * server is set that does not exist...  Does the message go to the   *\n\
=> * old default server - or does it generate an error.                 *\n\
=> **********************************************************************\n\n");
	fflush(stdout);
	cdevRequestObject * setDefReq = cdevRequestObject::attachPtr("device0", "set default");
	cdevRequestObject * req = cdevRequestObject::attachPtr("device0", "set attrib0");
	cdevData     data;
	int          val = 0;
	
	fprintf(stdout, "\n\
=> **********************************************************************\n\
=> * Commencing communications with MonitorTestServer (100 sends).      *\n\
=> **********************************************************************\n\n");
	fflush(stdout);
	data.insert("value", "MonitorTestServer");
	data.asciiDump();
	setDefReq->send(data, NULL);
	
	for(val=0; val<100; val++)
		{
		data.insert("value", val);
		req->send(data, NULL);
		}

	fprintf(stdout, "\n\
=> **********************************************************************\n\
=> * Now setting the default server to MonitorTestServer1... This       *\n\
=> * server should not exist. Performing 100 sends.                     *\n\
=> **********************************************************************\n\n");
	fflush(stdout);
	data.insert("value", "MonitorTestServer1");
	data.asciiDump();
	setDefReq->send(data, NULL);

	for(val=0; val<100; val++)
		{
		data.insert("value", val);
		req->send(data, NULL);
		}	

	fprintf(stdout, "\n\
=> **********************************************************************\n\
=> * Switching back to the other default server.                        *\n\
=> **********************************************************************\n\n");
	fflush(stdout);
	data.insert("value", "MonitorTestServer");
	data.asciiDump();
	setDefReq->send(data, NULL);
	
	for(val=0; val<100; val++)
		{   
		data.insert("value", val);
		req->send(data, NULL);
		}

	return 0;
	}
