#include "ClientAcceptor.h"
#include "ClientHandler.h"

// *****************************************************************************
// * ClientAcceptor:
// *	Default constructor for the ClientAcceptor class
// *****************************************************************************
ClientAcceptor::ClientAcceptor (cdevSessionManager & s) 
	: server(s) 
	{
	}


// *****************************************************************************
// * ClientAcceptor::~ClientAcceptor:
// *	Destructor for the ClientAcceptor class
// *****************************************************************************
ClientAcceptor::~ClientAcceptor (void) 
	{
	if(reactor) reactor->extractHandler(this);
	handleClose();	
	}

// *****************************************************************************
// * open:
// *	Initializes the listening socket
// *****************************************************************************
int ClientAcceptor::open (const cdevInetAddr &addr) 
	{
	int result = -1;
	if (this->acceptor.open (addr, TRUE) == -1) 
		{
		outputError(CDEV_SEVERITY_SEVERE, (char *)getName(), 
			    "Failed to open listening port");
		}
	else if (acceptor.setFlags (O_NONBLOCK) == -1) 
		{
		outputError(CDEV_SEVERITY_ERROR, (char *)getName(),
			    "Could not enable non-blocking I/O");
		}	
	else result = 0;
	return result;
	}

// *****************************************************************************
// * getHandle:
// *	Returns the device descriptor of the listening socket
// *****************************************************************************
int ClientAcceptor::getHandle   (void) const 
	{ 
	return acceptor.getHandle (); 
	}

// *****************************************************************************
// * handleInput:
// *	Accepts a connection on a listening socket and then creates a
// *	ClientHandler class to manage the connection.
// *****************************************************************************
int ClientAcceptor::handleInput (void) 
	{
	cdevInetAddr addr; 
	ClientHandler *svc_handler = new ClientHandler(server);
	if (acceptor.accept (*svc_handler, &addr) != -1) 
		{
		svc_handler->open(this);
		}
	else
		{
		outputError(CDEV_SEVERITY_ERROR, (char *)getName(),
			    "Failed to accept connection");
		}
	// *********************************************************************
	// * Always return 0... Otherwise, the accepting socket will
	// * be destroyed and a crippled server is all that will remain.
	// *********************************************************************
	return 0;
	}

// *****************************************************************************
// * handleClose:
// *	Closes the listening socket
// *****************************************************************************
int ClientAcceptor::handleClose (void)
	{
	acceptor.close ();
	return 0;
	}
