//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      rsvcServerStore Class for JLAB Control System Use Only
//
//      This is a storage class for all network servers running
//      in the JLAB control system
//
//      This database has a fixed definition as the following
//      "table"                  "cdevServers"
//      "key"                    "svid"
//      "keyExp"                 "name+domain"
//      "keyType"                RSVC_STRING
//      "name"                   RSVC_STRING
//      "domain"                 RSVC_STRING
//      "host"                   RSVC_STRING
//      "owner"                  RSVC_STRING
//      "time"                   RSVC_LONG
//      "port"                   LONG
//      "pid"                    LONG
//
//       the following are appended by this class
//                               0 --> active
//      "status"                 1 --> dormant
//                               2 --> dead
//                               3 --> newserver
//
//                               0 --> normal
//      "severity"               1 --> minor
//                               2 --> major
//
//      "ping"                   RSVC_LONG
//      "client"                 RSVC_LONG
//
//      
//
//
// Author:  Jie Chen
//
//
//
#ifndef _RSVC_SERVER_STORE_H
#define _RSVC_SERVER_STORE_H

#ifdef _CDEV_MANAGE_SERVERS

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#ifdef _WIN32
#include <sys/types.h>
#include <sys/timeb.h>
#else
#include <unistd.h>
#endif

#include <rsvcDataStoreMem.h>

class rsvcCacheData;

class rsvcServerStore: public rsvcDataStoreMem
{
public:
  // constructor
  rsvcServerStore   (void);
  ~rsvcServerStore  (void);

  // inherited operations
  virtual int putValue      (rsvcNetData& incoming,
			     rsvcNetData* outdata[], size_t* num,
			     int overwrite = 0);

  virtual int setValue      (rsvcNetData& incoming,
			     rsvcNetData* outdata[], size_t* num);

  virtual void handleClose  (void* ptr);

  // check all data inside table
  void         checkAll     (void);

protected:
  // check whether a data is valid or not by checking
  // status field of cached data
  int          dataValid    (rsvcCacheData* data);

  // update ping number
  void         ping         (rsvcCacheData* data);

  // check ping number      
  void         checkPing    (rsvcCacheData* data);

private:
  // Fixed table definition
  rsvcData     tdata_;
};
#endif

#endif
