//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      RSVC TCP IO handler (Generic Class)
//
// Author:  Jie Chen
//
//
//
#ifndef _RSVC_IO_H
#define _RSVC_IO_H

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <time.h>
#include <rsvcData.h>
#include <rsvcNetData.h>
#include <rsvcStreamMsg.h>
#include <rsvcSlist.h>
#include <rsvcDataStoreTable.h>

#include <cdevSocketStream.h>
#include <cdevAddr.h>
#include <cdevEventHandler.h>
#include <cdevReactor.h>

class rsvcAcceptor;

class rsvcIO: public cdevEventHandler
{
public:
  // constructor
  rsvcIO                    (cdevReactor& r, rsvcAcceptor* acceptor,
			     rsvcDataStoreTable& st);

  // destructor
  virtual ~rsvcIO           (void);

  // remember connected peer address
  int peerAddr              (const cdevInetAddr & addr);

  // conversion operator for SOCK_Stream
  operator cdevSocketStream & (void);

  // set socket options
  int setSockOption          (int level, int option, void* optval, 
			      int optlen) const;

  // send result to the connected peer
  int sendToPeer           (rsvcNetData* data);

  // return socket file descriptor
  int getHandle            (void) const;

  // enable/disable socket io options
  void enable               (int num);
  void disable              (int num);

protected:
  // handle socket close 
  int handleClose          ( void );

  // handleOutput
  int handleOutput         ( void );

  // handleInput
  int handleInput          ( void );

  // write msg buffer
  int writeStreamBuffer     (void);

  // shutdown this io stream
  void shutdownIO           (void);

  // handle process data
  int  processData          (rsvcNetData& data);

  // all those processing functions
  int  createMemTable       (rsvcNetData& ndata);

  int  openTable            (rsvcNetData& ndata);

  int  insertValue          (rsvcNetData& ndata, int overwrite = 0);

  int  getValue             (rsvcNetData& ndata);

  int  delValue             (rsvcNetData& ndata);

  int  setValue             (rsvcNetData& ndata);

  int  monitorValue         (rsvcNetData& ndata);

  int  monitorOffValue      (rsvcNetData& ndata);

  int  monitorAttr          (rsvcNetData& ndata);

  int  monitorOffAttr       (rsvcNetData& ndata);

  int  monitorEntries       (rsvcNetData& ndata);

  int  monitorOffEntries    (rsvcNetData& ndata);

  int  query                (rsvcNetData& ndata);

  // connection to remote client
  cdevSocketStream           sockStream_;
  // Reactor reference
  cdevReactor &              reactor_;
  // client host address
  char*                     clientHost_;
  // acceptor that creates this IO
  rsvcAcceptor*             acceptor_;

  // data queue for writing
  rsvcQueue                 dataQueue_;

  // current writing msg
  rsvcStreamMsg             wmsg_;

  // output data streaming buffer
  char*                     dbuffer_;
  size_t                    dbuflen_;

  // input data convertion buffer
  char*                     ibuffer_;
  size_t                    ibuflen_;

  // data store index table
  rsvcDataStoreTable&       storeTable_;

  // flag to tell whether write mask is set or not
  int                       wmaskSet_;

  // deny copy and assignment operations
  rsvcIO (const rsvcIO& io);
  rsvcIO& operator = (const rsvcIO& io);
};
#endif
