#if !defined (_CDEV_SOCKET_STREAM_H)
#define _CDEV_SOCKET_STREAM_H

#include "cdevSocket.h"
#include <signal.h>


class CDEV_REACTOR_API cdevSocketStream : public cdevSocket
{
public:
	cdevSocketStream           (void);
	ssize_t     send           (const void *buf, size_t n, int flags=0) const;
	ssize_t     recv           (void *buf, size_t n, int flags=0);
	ssize_t     send_n         (const void *buf, size_t n, int flags=0) const;
	ssize_t     recv_n         (void * buf, size_t n, int flags=0);
	
	int         closeReader    (void);
	int         closeWriter    (void);
	
	virtual int getBlockingSemantics ( void ) const;
	virtual int getRcvLowWaterMark   ( void ) const;
	virtual int getSndLowWaterMark   ( void ) const;
	virtual int getRcvBufferSize     ( void ) const;
	virtual int getSndBufferSize     ( void ) const;
	virtual int configureHandle      ( void );
};

#endif 	/* _CDEV_SOCKET_STREAM_H_ */		

