#ifndef _CDEV_PACKET_
#define _CDEV_PACKET_

#include <cdevPacketBinary.h>

class GENERIC_SERVER_API cdevPacket
{
public:
	typedef cdevPacket * (*ImportMethod)(cdevPacketBinary &);

	typedef struct
		{
		short        packetVersion;
		ImportMethod importMethod;
		} ImportTable;

	static  cdevPacket * import               ( cdevPacketBinary & );
	static  void         registerImportMethod ( short, ImportMethod );

	cdevPacket                     ( void ) {}
	virtual         ~cdevPacket    ( void ) {}

	virtual int      streamIn      ( char * binary, size_t binaryLen ) = 0;
	virtual int      streamOut     ( char ** binary, size_t * binaryLen ) = 0;
	virtual void     asciiDump     ( FILE * fp = stdout ) = 0;
	
	virtual short    getVersion    ( void ) = 0;
	virtual short    getClientID   ( void ) = 0;
	virtual void     setClientID   ( short ClientID ) = 0;

private:
	static ImportTable * importTables;
	static int           maxTables;
};
#endif
