#ifndef _CDEV_CONTEXT_MAP_H_
#define _CDEV_CONTEXT_MAP_H_ 1
#include <cdevPlatforms.h>
#include <cdevData.h>


// *****************************************************************************
// * class cdevContextMap :
// *	The purpose of this class is to allow the user to store a list of 
// *	commonly used context cdevData items.  This will allow the caller to
// *	pass the context to maintain a list of contexts that are identifiable
// *	by a unique integer identifier...
// *****************************************************************************
class GENERIC_SERVER_API cdevContextMap
{
protected:
	cdevData ** entries;
	size_t      maximum;
	size_t      cnt;

	void       resize    ( void );
	
public:
	cdevContextMap       ( void );
	~cdevContextMap      ( void );
	int        insert    ( cdevData & context );
	int        find      ( cdevData & context );
	cdevData * find      ( int idx ) { return (idx>cnt || idx<0)?(cdevData *)NULL:entries[idx]; }
	void       asciiDump ( FILE * fp = stdout );
};

#endif /* _CDEV_CONTEXT_MAP_H_ */

