#ifndef _SIGNAL_MANAGER_H_
#define _SIGNAL_MANAGER_H_

#include <signal.h>
#include <stdlib.h>
#include <cdevPlatforms.h>
#include <ErrorReporter.h>

typedef void (*SignalHandlerFunc)( int );

class GENERIC_SERVER_API _SignalHandler_ 
{
public:
	_SignalHandler_  ( void );
	~_SignalHandler_ ( void );
	void install   ( int, SignalHandlerFunc);
	void uninstall ( void );
	
private:	
	int               signo;
	SignalHandlerFunc handler;
	SignalHandlerFunc oldHandler;
};
	
class GENERIC_SERVER_API SignalManager
{
public:
	static ErrorReporter reporter;	

	void installHandler         ( int, SignalHandlerFunc );
	void uninstallHandler       ( int );
	void installDefaults        ( void );

	static void defaultHandler  ( int );

private:
	enum { MAXSIGNAL = 34 };
	_SignalHandler_ signals[MAXSIGNAL];
};

#endif  /* _SIGNAL_MANAGER_H_ */
