#ifndef _ERROR_REPORTER_H_
#define _ERROR_REPORTER_H_ 1

#include <cdevPlatforms.h>

#ifndef _NO_CDEV_SYSTEM_
	#include <cdevSystem.h>
	#include <cdevErrCode.h>
#else
	#include <stdarg.h>
	#ifndef CDEV_SEVERITY_INFO		/* cdevError class severity codes  */
		#define CDEV_SEVERITY_INFO      0 /* informative message           */
		#define CDEV_SEVERITY_WARN      1 /* warning message               */
		#define CDEV_SEVERITY_ERROR     2 /* error message                 */
		#define CDEV_SEVERITY_SEVERE    3 /* severe or fatal error message */
	#endif
#endif

class GENERIC_SERVER_API ErrorReporter
{
public:
	ErrorReporter            ( void ) {}
	virtual ~ErrorReporter   ( void ) {}
	virtual int outputError  ( int severity, const char *name, const char *formatString, ... )
		{
		int result = 0;
		
		va_list argp;
		va_start (argp, formatString);
		
		#ifndef _NO_CDEV_SYSTEM_
			result = cdevSystem::defaultSystem().vreportError(severity, name, NULL, formatString, argp);
		#else
			fprintf(stdout,"%s %s: ",
				name,
				(severity==CDEV_SEVERITY_INFO?"Information":
				(severity==CDEV_SEVERITY_WARN?"Warning":
				(severity==CDEV_SEVERITY_ERROR?"Error":
				(severity==CDEV_SEVERITY_SEVERE?"Severe Error":
				"Event")))));
			vfprintf(stdout, formatString, argp);
			fprintf (stdout, "\n");
		#endif		
		va_end(argp);
		return result;
		}
};

#endif /* _ERROR_REPORTER_H_ */
