#include <cdevPlatforms.h>
#include <cdevData.h>


// *****************************************************************************
// * class cdevTagMap:
// *	The purpose of the cdevTagMap is to allow rapid translation between 
// *	the cdev tag tables that within different processes.  
// *
// *	This class provides the capability to switch back and forth from the
// *	local tag values to the remote tag values.
// *****************************************************************************
class GENERIC_SERVER_API cdevTagMap
{
private:
	int   cnt;
	int   maximum;
	int * local;
	int * remote;

public:
	cdevTagMap         ( void );
	~cdevTagMap        ( void );
	void updateTagMap  ( cdevData & data );
	void updateTagMap  ( char ** names, int * tags, int count );
	void swapTags      ( cdevData & data, int *inTags, int *outTags, int count);
	void localToRemote ( cdevData & data ) { if(cnt) swapTags(data, remote, local, cnt); }
	void remoteToLocal ( cdevData & data ) { if(cnt) swapTags(data, local, remote, cnt); }
	void asciiDump     ( FILE * fp = stdout );
};	
		
