#include "cdevSocketDatagram.h"

int cdevSocketDatagram::open ( const cdevAddr &addr, int protocol_family, int protocol )
	{
	int result = 0;

	if((result = cdevSocket::open(SOCK_DGRAM, protocol_family, protocol))!=-1)
		{
		result = bind(getHandle(), (sockaddr *)addr.getAddress(), addr.getSize());
		}
	if(result!=0) close();

	return result;
	}		


ssize_t cdevSocketDatagram::send (const void *buf, size_t n, const cdevAddr &addr, int flags) const
	{
	sockaddr *saddr = (sockaddr *) addr.getAddress ();
	size_t   len	= addr.getSize ();
	return sendto (this->getHandle (), (const char *) buf, n, flags, (struct sockaddr *) saddr, len);
	}


ssize_t cdevSocketDatagram::recv (void *buf, size_t n, cdevAddr &addr, int flags) const
	{
	sockaddr *saddr   = (sockaddr *) addr.getAddress();
	int	  len     = addr.getSize();
	ssize_t   status  = recvfrom (this->getHandle(), (char *)buf, n, flags, (sockaddr *) saddr, (SOCKOPT_SIZE_PARM *)&len);
  	addr.setSize (len);
  	return status;
	}


cdevSocketDatagram::cdevSocketDatagram ( void ) 
	{
	}
	

cdevSocketDatagram::cdevSocketDatagram ( const cdevAddr &addr, int protocol_family, int protocol )
	{
	open(addr, protocol_family, protocol);
	}

