.SUFFIXES: .cc .obj

ARCH             = WINNT-4.0
SHOBJ            = YES
APPNAME          = CDEV Reactor Library

include ..\include\makeinclude\Makefile.WINNT-4.0

OBJS           = $(OBJDIR)/cdevAddr.obj\
                 $(OBJDIR)/cdevEventHandler.obj\
                 $(OBJDIR)/cdevHandleSet.obj\
                 $(OBJDIR)/cdevReactor.obj\
                 $(OBJDIR)/cdevSocket.obj\
                 $(OBJDIR)/cdevSocketAcceptor.obj\
                 $(OBJDIR)/cdevSocketConnector.obj\
                 $(OBJDIR)/cdevSocketDatagram.obj\
                 $(OBJDIR)/cdevSocketStream.obj\
                 $(OBJDIR)/cdevStreamNode.obj\
                 $(OBJDIR)/cdevStreamQueue.obj\
                 $(OBJDIR)/cdevTime.obj

CXXEXTRA       = /D "_CDEV_REACTOR_EXPORTS_=1"

# ******************************************************************************
# * The BINARIES definition names all of the binary files that should be deleted
# * whenever "make clean" is executed.
# ******************************************************************************
BINARIES    = $(BASELIB)\cdevReactor.dll \
	      $(BASELIB)\cdevReactor.lib

# ******************************************************************************
# * The TARGETS variable is used to specify the name of the library to build. 
# ******************************************************************************
!IF "$(SHOBJ)" == "YES"
TARGETS = $(CDEVLIB)\cdevReactor.dll
!ELSE
TARGETS = $(CDEVLIB)\cdevReactor.lib
!ENDIF

targets : $(TARGETS)
	
$(CDEVLIB)\cdevReactor.lib : $(OBJS)
	@echo =^> Building $(@F) 
	@echo =^> Objects: $(?F)
	-@if exist $@ erase $@
	$(LIB32) $(LINK_LIB_FLAGS) /out:$@ $(OBJS)
	@echo ^<= Done...

$(CDEVLIB)\cdevReactor.dll : $(OBJS)
	@echo =^> Building $(@F) 
	@echo =^> Objects: $(?F)
	-@if exist $@ erase $@
	$(LIB32) $(LINK_DLL_FLAGS) /out:$@ /implib:$(@D)\$(@B).lib $(OBJS)
	@echo ^<= Done...
