//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      RSVC UDP Client 
//
//      This is very limited, it only allows update to a single table
//      Internal CEBAF use only      
//
// Author:  Jie Chen
//
//   
//
//
#ifndef _RSVC_UDP_CLIENT_H
#define _RSVC_UDP_CLIENT_H

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>

#ifdef _WIN32
#include <winsock2.h>
#else
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#endif

#include <rsvcData.h>
#include <rsvcNetData.h>
#include <rsvcConfig.h>

class RSVC_CLASS_SPEC rsvcUdpClient
{
public:
  // constructor
  rsvcUdpClient     (void);
  ~rsvcUdpClient    (void);

  int connect       (char* host, unsigned short port);

  int update        (rsvcData& data);

  int disconnect    (void);

private:
  // stream a data object
  int streamData    (rsvcNetData& data);

  // open udp port
  int openUdpPort   (char* host, unsigned short port);

  // udp socket
  struct sockaddr_in udp_addr_;
  int                fd_;
  // data convertion buffer
  char               obuffer_[RSVC_UDP_BUFFER_SIZE];
};
#endif

