//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of rsvcStreamMsg Class
//
// Author:  Jie Chen
//
// Revision History:
//   rsvcStreamMsg.cc,v
// Revision 1.1  1998/01/22  17:08:23  akers
// Addition of new NameServer
//
//
//
#include <rsvcNetData.h>
#include "rsvcStreamMsg.h"

rsvcStreamMsg::rsvcStreamMsg (void)
:buffer_ (0), buflen_ (0), cursor_ (0), deleteBuffer_ (0), active_ (0)
{
#ifdef _TRACE_OBJECTS
  printf ("Create rsvcStreamMsg Class Object\n");
#endif
  //empty
}

rsvcStreamMsg::rsvcStreamMsg (char* data, size_t len, int deletebuf)
:buffer_ (data), buflen_ (len), deleteBuffer_ (deletebuf), active_ (0)
{
#ifdef _TRACE_OBJECTS
  printf ("Create rsvcStreamMsg Class Object\n");
#endif
  cursor_ = 0;
}

rsvcStreamMsg::rsvcStreamMsg (rsvcNetData* data)
{
#ifdef _TRACE_OBJECTS
  printf ("Create rsvcStreamMsg Class Object\n");
#endif

  char* buffer;
  size_t len;

  if (data->streamOut (&buffer, &len) == RSVC_SUCCESS) {
    buffer_ = buffer;
    buflen_ = len;
    deleteBuffer_ = 1;
    cursor_ = 0;
    active_ = 0;
  }
  else {
    buffer_ = 0;
    buflen_ = 0;
    deleteBuffer_ = 0;
    cursor_ = 0;
    active_ = 0;
  }
}

rsvcStreamMsg::~rsvcStreamMsg (void)
{
#ifdef _TRACE_OBJECTS
  printf ("Delete rsvcStreamMsg Class Object\n");
#endif
  if (buffer_ && deleteBuffer_) 
    delete []buffer_;
}

size_t
rsvcStreamMsg::length (void) const
{
  return buflen_;
}

void
rsvcStreamMsg::length (size_t size)
{
  buflen_ = size;
}

char*
rsvcStreamMsg::base (void) const
{
  return buffer_;
}

char*
rsvcStreamMsg::actionPtr (void) const
{
  return &(buffer_[cursor_]);
}

void
rsvcStreamMsg::actionPtr (char* p)
{
  if (p < buffer_ || p > &(buffer_[buflen_ - 1])) {
    fprintf (stderr, "Fatal Error: rsvcStreamMsg actionPtr overflow\n");
    return;
  }
  cursor_ = p - buffer_;
  active_ = 1;
}

void
rsvcStreamMsg::actionPtr (size_t n)
{
  cursor_ += n;
  active_ = 1;
}

size_t
rsvcStreamMsg::size (void)
{
  if (cursor_ >= buflen_)
    return 0;
  else
    return (buflen_ - cursor_);
}

int
rsvcStreamMsg::endMsg (void)
{
  return (cursor_ >= buflen_);
}

void
rsvcStreamMsg::reset (void)
{
  cursor_ = 0;
  active_ = 0;
}

void
rsvcStreamMsg::attach (char* data, size_t size, int deleteit)
{
  buffer_ = data;
  buflen_ = size;
  deleteBuffer_ = deleteit;
  cursor_ = 0;
  active_ = 0;
}

int
rsvcStreamMsg::active (void) const
{
  return active_;
}

void
rsvcStreamMsg::resize (void)
{
  char* newbuffer = new char[2*buflen_];
  memcpy (newbuffer, buffer_, buflen_);
  buflen_ = 2*buflen_;
  delete []buffer_;
  buffer_ = newbuffer;
}


