//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      RSVC Local Configuration Routines
//
// Author:  Jie Chen
//
// Revision History:
//   rsvcLocalConfig.cc,v
// Revision 1.3  1998/02/26  19:11:45  chen
// use reguler timer instead of sig alarm to scan server entries
//
// Revision 1.2  1998/01/29  19:11:01  akers
// Ongoing development
//
// Revision 1.1  1998/01/22  17:08:15  akers
// Addition of new NameServer
//
//
//
#ifdef _CDEV_MANAGE_SERVERS

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#ifndef _WIN32
#include <unistd.h>
#endif

#include <signal.h>
#include <rsvcServerStore.h>
#include <rsvcDataStoreTable.h>
#include <cdevReactor.h>

extern cdevReactor* rsvc_reactor;

class rsvcServerEntryScanTask : public cdevEventHandler
{
public:
  // constructor
  rsvcServerEntryScanTask  (rsvcServerStore* serverStore);
  // destructor
  ~rsvcServerEntryScanTask (void);

  int handleTimeout        (void);

private:
  rsvcServerStore* serverStore_;
};

rsvcServerEntryScanTask::rsvcServerEntryScanTask (rsvcServerStore* store)
:cdevEventHandler (), serverStore_ (store)
{
#ifdef _TARCE_OBJECTS
  printf ("    Create rsvcServerEntryScanTask Class Object\n");
#endif
  setTimeoutRate ((double)_RSVC_CDEV_SCAN_PERIOD);
}

rsvcServerEntryScanTask::~rsvcServerEntryScanTask (void)
{
#ifdef _TARCE_OBJECTS
  printf ("    Delete rsvcServerEntryScanTask Class Object\n");
#endif
  // server store will be deleted by data store table
}


int
rsvcServerEntryScanTask::handleTimeout (void)
{
  serverStore_->checkAll ();
  return 0;
}

void rsvcLocalConfig (rsvcDataStoreTable& table)
{
  rsvcServerStore *serverStore = new rsvcServerStore ();

  if (serverStore->openDatabase () != RSVC_SUCCESS) {
    fprintf (stderr, "Cannot open cdev server management service\n");
    exit (1);
  }
  table.add (serverStore);

  // spawn a timer to scan all data entries
  rsvcServerEntryScanTask* scanTask = new rsvcServerEntryScanTask(serverStore);
  if (rsvc_reactor) {
    rsvc_reactor->registerTimer (scanTask);
  }
}

#else
void rsvcLocalConfig (class rsvcDataStoreTable& /* table */)
{
  
}
#endif


  
