//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      Implementation of database environment
//
// Author:  Jie Chen
//
// Revision History:
//   rsvcDatabaseEnv.cc,v
// Revision 1.1  1998/01/22  17:08:10  akers
// Addition of new NameServer
//
//
//
#include "rsvcDatabaseEnv.h"
#include "rsvcServerConfig.h"

rsvcDatabaseEnv* rsvcDatabaseEnv::env_ = 0;

rsvcDatabaseEnv::rsvcDatabaseEnv (void)
{
#ifdef _TRACE_OBJECTS
  printf ("Create rsvcDatabaseEnv Class Object\n");
#endif
  dbenv_ = new DB_ENV ();
  if (dbenv_ == 0) {
    fprintf (stderr, "Cannot allocate memory for DB_ENV structure\n");
    exit (1);
  }
  dbenv_->db_errfile = stderr;
  dbenv_->db_errpfx = "rsvcDatabase";
  if (db_appinit (rsvcServerConfig::dbaseHome (), 0, dbenv_, DB_CREATE) != 0){
    fprintf (stderr, "dp_appinit failed \n");
    exit (1);
  }
}

rsvcDatabaseEnv::~rsvcDatabaseEnv (void)
{
#ifdef _TRACE_OBJECTS
  printf ("Delete rsvcDatabaseEnv Class Object\n");
#endif
  db_appexit (dbenv_);
  delete dbenv_;
}

rsvcDatabaseEnv *
rsvcDatabaseEnv::dbaseEnv (void)
{
  if (rsvcDatabaseEnv::env_ == 0)
    rsvcDatabaseEnv::env_ = new rsvcDatabaseEnv ();
  return rsvcDatabaseEnv::env_;
}

DB_ENV *
rsvcDatabaseEnv::dbenv (void) const
{
  return dbenv_;
}

void
rsvcDatabaseEnv::close (void)
{
  if (rsvcDatabaseEnv::env_)
    delete rsvcDatabaseEnv::env_;
}


