//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      C++ wrapper class for DBT class with user allocated memory
//
//      Reason: Enable automatic memory release
//
// Author:  Jie Chen
//
//
//
#ifndef _RSVC_DBT_H
#define _RSVC_DBT_H

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <db.h>

class rsvcDBT
{
public:
  rsvcDBT  (void);
  ~rsvcDBT (void);

  void*    data (void) const;
  void     data (void *ptr, int dealloc = 1);
  size_t   size (void) const;
  void     size (size_t len);
  void     datacpy (void* data);

  // return data pointer to internal DBT
  DBT*     dbt  (void);

private:
  DBT      data_;
  int      dealloc_;
};
#endif
