//-----------------------------------------------------------------------------
// Copyright (c) 1994,1995 Southeastern Universities Research Association,
//                         Continuous Electron Beam Accelerator Facility
//
// This software was developed under a United States Government license
// described in the NOTICE file included as part of this distribution.
//
//-----------------------------------------------------------------------------
//
// Description:
//      Name Server Monitor Object
//
// Author:  Jie Chen
//
//
//
#ifndef _RNS_MONITOR_OBJ_H
#define _RNS_MONITOR_OBJ_H

#include <cdevMonitorObj.h>

class rnsRequestObject;

class rnsMonitorObj : public cdevMonitorObj
{
public:
  // constructor and destructor
  rnsMonitorObj (cdevTranObj& tranObj)
    :cdevMonitorObj (tranObj), out_ (0), started_ (1)
      {
#ifdef _TRACE_OBJECTS
	printf ("              Create rnsMonitorObj Class Object\n");
#endif
      }

  ~rnsMonitorObj (void)
    {
#ifdef _TRACE_OBJECTS
      printf ("              Delete rnsMonitorObj Class Object\n");
#endif
      if (out_)
	delete out_;
    }

  const char* className (void) const {return "rnsMonitorObj";}

  // out bound cdevdata
  cdevData* out_;
  
  // whether this monitor callback is restarted or not
  int       started_;
};
#endif

