!IF "$(VERBOSE)" != "YES"
MAKE = $(MAKE) -s VERBOSE=NO
!ENDIF

BASEDIR      = $(MAKEDIR)

SERVER_DIR   = $(BASEDIR)\server
SERVICE_DIR  = $(BASEDIR)\service
APP_DIR      = $(BASEDIR)\test

CLEAN_DIRS   = $(SERVER_DIR)\
               $(SERVICE_DIR)\
			   $(APP_DIR)
			   
			   
all:
	@echo =^> Building CDEV Gateway Client/Server
	@for %d in ($(SERVER_DIR) $(SERVICE_DIR)) do @cd %d & $(MAKE) /NOLOGO /f NMakefile.mak
	@echo ^<= Done...	
	

apps:
	@echo =^> Building Test Applications
	@for %d in ($(APP_DIR)) do @cd %d & $(MAKE) /NOLOGO /f NMakefile.mak
	@echo ^<= Done...	


clean:
	@echo =^> Cleaning CDEV Gateway Directories
	@for %d in ($(CLEAN_DIRS)) do @cd %d & $(MAKE) /NOLOGO /f NMakefile.mak clean
	@echo ^<= Done...
	
purge:
	@echo =^> Purging CDEV Gateway Directories
	@for %d in ($(CLEAN_DIRS)) do @cd %d & $(MAKE) /NOLOGO /f NMakefile.mak purge
	-@rmdir /s /q $(BASEDIR)\bin
	@echo ^<= Done...
