#!/usr/local/bin/wish4.2
#############################################################################
# Visual Tcl v1.08 Project
#

#################################
# GLOBAL VARIABLES
#

#################################
# USER DEFINED PROCEDURES
#
#proc source file {uplevel #0 [exec tcl_cruncher -s $file]}
proc init {argc argv} {
    global env
    global cleanup_armed
    set cleanup_armed 0;
    global cleanup_armed; set cleanup_armed {0}
    image create photo coda_logo -file $env(CODA)/common/images/gif/RCLogo.gif
    image create photo icon_button -file $env(CODA)/common/images/gif/iconify.gif
    image create photo warn_skull -file $env(CODA)/common/images/gif/skull.gif
    image create photo splash_creen -file $env(CODA)/common/images/gif/splash.gif
}

init 0 {}


proc arm_cleanup {} {
global cleanup_armed
    if {$cleanup_armed == 0} {
	set cleanup_armed 1;
	.monitor.top.controls.cleanup.cleanup configure -state normal
	.monitor.top.controls.cleanup.arm configure -text Disarm
	.monitor.top.controls.cleanup.warning configure -image warn_skull
	flash_b
    } else {
	set cleanup_armed 0;
	.monitor.top.controls.cleanup.arm configure -text ARM
    }
}

proc chartplot {chart xinterval yvalue} {
set w .monitor.top.graphs.cpd35
    set opts [$w element configure $chart]
    foreach opt $opts {
	set optname [lindex $opt 0]
	if {"$optname"=="-xdata"} {
	    set xdata [lindex $opt 4]
	}
	if {"$optname"=="-ydata"} {
	    set ydata [lindex $opt 4]
	}
    }
    if {[lindex $xdata end] > 60.0} {
	set xdata [lrange $xdata 1 end]
	set ydata [lrange $ydata 1 end]
    }
    lappend xdata [expr [lindex $xdata end]+$xinterval]
    lappend ydata $yvalue

    $w element configure $chart -xdata $xdata -ydata $ydata
}

proc chartzero {} {
set w .monitor.top.graphs.cpd35
    $w element configure fifo0 -foreground red -xdata 0.0 -ydata 0.0
    $w element configure fifo1 -foreground green -xdata 0.0 -ydata 0.0
    $w element configure fifo2 -foreground blue -xdata 0.0 -ydata 0.0
    $w element configure fifo3 -foreground black -xdata 0.0 -ydata 0.0
    $w element configure fifo4 -foreground yellow -xdata 0.0 -ydata 0.0
    $w element configure fifo5 -foreground brown -xdata 0.0 -ydata 0.0
    $w element configure fifo6 -foreground pink -xdata 0.0 -ydata 0.0
    $w element configure fifo7 -foreground lightblue -xdata 0.0 -ydata 0.0
    $w element configure fifo8 -foreground orange -xdata 0.0 -ydata 0.0
    $w element configure fifo9 -foreground purple -xdata 0.0 -ydata 0.0
}

proc do_dd_cleanup {} {
global cleanup_armed

    # First cleanup dd processes...
    set me [exec whoami]

    set ps_res [exec ps -u $me -o pid,comm]

    set procs [lrange [split $ps_res \n] 1 end]

    foreach pr $procs {
	if {[regexp .*dd_.* [lindex $pr 1]]} {
	    puts "found $pr pid [lindex $pr 0]"
	    exec kill -9 [lindex $pr 0]
	}
    }
    # now clean up semaphores and shared memory...
    set ipc [exec ipcs]

    set ipc [split $ipc \n]

    foreach line $ipc {
	if {[scan $line m%d mem]} {
	    exec ipcrm -m $mem
	}
	if {[scan $line s%d sem]} {
	    exec ipcrm -s $sem
	}
	
    }
    set cleanup_armed 0;
    .monitor.top.controls.cleanup.arm configure -text ARM
}

proc flash_b {} {
global cleanup_armed
    set w .monitor.top.controls.cleanup.cleanup

    if {$cleanup_armed == 0} {
	$w configure -state disabled -background lightgrey
	.monitor.top.controls.cleanup.warning configure -image ""
	return
    }

    set bg [$w cget -background]

    if {"$bg" == "lightgrey"} {
	$w configure -background red
    } else {
	$w configure -background lightgrey
    }
    after 1000 flash_b
}

proc formatlabel {w value} {
# Determine the element name from the value
    set displaylist [$w element show]
    set index [expr round($value)]
    set name [lindex $displaylist $index]
    if { $name == "" } { 
	return $name
    }
    # Return the element label
    set info [$w element configure $name -label]
    return [lindex $info 4]
}

proc graph {w x y xtitle ytitle} {
$w xaxis configure -title $xtitle -command formatlabel    

    $w legend configure -mapped 0
    $w yaxis configure  -title $ytitle -max $y
    for { set i 0 } { $i <= $x } { incr i } {
	$w element create $i  -data { $i 0 }  -relief raised  -label "FIFO $i"  -foreground blue  -bd 2
    }

    $w element configure 0 -foreground red
    $w element configure $x -foreground green
}

proc graphlabel {w element label} {
$w element configure $element -label $label
}

proc graphplot {w element data} {
$w element configure $element -ydata $data
}

proc main {argc argv} {
    wm focusmodel .monitor passive
    #set h [winfo vrootheight .monitor]
    #set w [winfo vrootwidth .monitor]
    #wm geometry .monitor [set w]x[set h]+0+0
    #wm maxsize .monitor $w $h
    #wm minsize .monitor $w $h
    #wm overrideredirect .monitor 1
    #    wm overrideredirect .monitor 0
    #wm resizable .monitor 0 0
    #wm sizefrom .monitor user
    graph .monitor.top.graphs.cpd34 10 256  "Fifo name" "buffers"
    graph .monitor.top.graphs.cpd36 10 10  "Fifo name" "k events/Sec"
    .monitor.top.cpd27.03 tag configure  title -relief raised -borderwidth 1 -font -*-courier-medium-r-normal--*-140-*
    .monitor.top.cpd27.03 tag configure  subtitle -relief raised -background lightgrey -borderwidth 1 
    .monitor.top.cpd27.03 tag configure  data  -relief sunken -borderwidth 1 -background lightgrey

    # set up the chart recorder..
    set w .monitor.top.graphs.cpd35
    if { "[winfo vrootwidth .monitor]" <= 1024 } {
	$w legend configure -mapped 0
    }
    $w yaxis configure -title "K events/S" -min 0.0
    $w xaxis configure -title "time (S)"


    $w element create fifo0 -foreground red -xdata 0.0 -ydata 0.0
    $w element create fifo1 -foreground green -xdata 0.0 -ydata 0.0
    $w element create fifo2 -foreground blue -xdata 0.0 -ydata 0.0
    $w element create fifo3 -foreground black -xdata 0.0 -ydata 0.0
    $w element create fifo4 -foreground yellow -xdata 0.0 -ydata 0.0
    $w element create fifo5 -foreground brown -xdata 0.0 -ydata 0.0
    $w element create fifo6 -foreground pink -xdata 0.0 -ydata 0.0
    $w element create fifo7 -foreground lightblue -xdata 0.0 -ydata 0.0
    $w element create fifo8 -foreground orange -xdata 0.0 -ydata 0.0
    $w element create fifo9 -foreground purple -xdata 0.0 -ydata 0.0

    # help stuff
    tixBalloon .monitor.help -statusbar .monitor.top.bottom.status

    set h .monitor.help

    $h bind .monitor.top.graphs.cpd35  -balloonmsg "Chart of event rate\nper second for \neach fifo."  -statusmsg "Chart of changes in event rate for each fifo in the DD system."

    $h bind .monitor.top.graphs.cpd36  -balloonmsg "Number of events\nper second passing\nthrough each fifo."  -statusmsg "Bar chart of event rate through each fifo in the DD system."

    $h bind .monitor.top.graphs.cpd34  -balloonmsg "Number of events \nin each fifo."  -statusmsg "Bar chart of number of events in each fifo in the DD system."

    set f .monitor.top.controls.cleanup

    $h bind $f.arm  -balloonmsg "Arm the DD-cleanup button\nDD-cleanup DELETES\nthe DD system."  -statusmsg "This a safety for the cleanup button. Press ARM to enable deleting the DD system."

    $h bind $f.cleanup  -balloonmsg "Delete the DD system."  -statusmsg "This button deletes the DD system, we hope that you know what you are doing"

    $h bind $f.warning  -balloonmsg "This label tells you\nif the cleanup button is\n in it's \"safe\" position."  -statusmsg "Read the little yellow postit!!"

    #$h bind .monitor.top.cpd26  -balloonmsg "click on a tab\nto change page."  -statusmsg "This is a notebook, clicking on the tabs at the top changes page."
    
    $h bind .monitor.top.cpd27.03 -balloonmsg "Status of DD System."  -statusmsg "This is the status of the DD system."
    
    $h bind .monitor.top.bottom.status  -balloonmsg "This text describes\nwhat the thing you\nare pointing at \ndoes."  -statusmsg "Read the little yellow postit!!"

    #after 10000 wm withdraw .splash
    wm deiconify .monitor
    if {![catch "info classes"]} {
	global env
	#source $env(CODA)/common/lib/xmon/procview.tcl
	#MainWin win.obj .monitor.top.cpd26.nbframe.roc.left
	
	# create a current State object
	
	#State currentState.obj

	#MainWin::chooseHost ""
	#MainWin::chooseDb $env(EXPID)
	#source $env(CODA)/common/lib/xmon/cmonitor.tcl
	#if {$argc} {
	#    MainWin::chooseSession [lindex $argv 0]
	#    CMONITOR monitor .monitor.top.cpd26.nbframe.roc.right [lindex $argv 0]
	#} else {
	#    CMONITOR monitor .monitor.top.cpd26.nbframe.roc.right
	#}
	#set w .monitor.top.cpd26.nbframe.roc.left
	#$h bind $w.f1.f2.f.canvas  -statusmsg "This is a display of the current configuration in graphical form"
    }
}

proc Window {args} {
global vTcl
    set cmd [lindex $args 0]
    set name [lindex $args 1]
    set rest [lrange $args 2 end]
    if {$name == "" || $cmd == ""} {return}
    set exists [winfo exists $name]
    switch $cmd {
        show {
            if {[info command vTclWindow(pre)$name] != ""} {
                vTclWindow(pre)$name $rest
            }
            if {[info command vTclWindow$name] != ""} {
                vTclWindow$name $rest
            }
            if {[info command vTclWindow(post)$name] != ""} {
                vTclWindow(post)$name $rest
            }
        }
        hide    { if $exists {wm withdraw $name; return} }
        iconify { if $exists {wm iconify $name; return} }
        destroy { if $exists {destroy $name; return} }
    }
}

#################################
# VTCL GENERATED GUI PROCEDURES
#

proc vTclWindow. {args} {
    set base .
    ###################
    # CREATING WIDGETS
    ###################
    wm focusmodel . passive
    wm geometry . 1024x748+0+0
    wm maxsize . 1024 748
    wm minsize . 1024 748
    wm overrideredirect . 0
    wm resizable . 1 1
    wm withdraw .
    wm title . "vt.tcl"
    ###################
    # SETTING GEOMETRY
    ###################
}

proc vTclWindow.monitor {args} {
    set base .monitor
    if {[winfo exists .monitor]} {
        wm deiconify .monitor; return
    }
    ###################
    # CREATING WIDGETS
    ###################
    if { "$args" != "{}" } {
	puts "user $args"
	toplevel .monitor -use [lindex $args 0] -class Toplevel \
	    -background lightgray -highlightbackground lightgray 
	bind .monitor <Destroy> {puts "DDMON: runcontrol has quit.";exit}	
    } else {
	toplevel .monitor -class Toplevel \
	    -background lightgray -highlightbackground lightgray 
    }
    wm focusmodel .monitor passive
    #wm geometry .monitor 1152x870+4+25
    #wm maxsize .monitor 1152 870
    #wm minsize .monitor 1152 870
    #wm overrideredirect .monitor 0
    #wm resizable .monitor 0 0
    #wm deiconify .monitor
    wm title .monitor "monitor"
    frame .monitor.top \
        -background lightgray -borderwidth 1 -height 30 \
        -highlightbackground lightgray -relief raised -width 30 

    frame .monitor.top.controls \
        -background lightgray -borderwidth 1 -height 30 \
        -highlightbackground lightgray -relief sunken -width 30 
    frame .monitor.top.controls.cleanup \
        -background lightgray -borderwidth 1 -height 30 \
        -highlightbackground lightgray -relief sunken -width 30 
    button .monitor.top.controls.cleanup.arm \
        -activebackground gray -activeforeground black -background lightgray \
        -command arm_cleanup -font -Adobe-Helvetica-Medium-R-Normal--*-120-* \
        -foreground black -highlightbackground lightgray -padx 11 -pady 4 \
        -text ARM 
    button .monitor.top.controls.cleanup.cleanup \
        -activebackground gray -activeforeground black -background lightgray \
        -command do_dd_cleanup \
        -font -Adobe-Helvetica-Medium-R-Normal--*-120-* -foreground black \
        -highlightbackground lightgray -padx 11 -pady 4 -text cleanup 
    label .monitor.top.controls.cleanup.warning \
        -anchor w -background lightgray -borderwidth 0 \
        -font -Adobe-Helvetica-Bold-R-Normal--*-120-* -foreground black \
        -highlightbackground lightgray -relief groove -text safe 
    frame .monitor.top.cpd27 \
        -background lightgray -borderwidth 1 -height 30 \
        -highlightbackground lightgray -relief raised -width 30 
    scrollbar .monitor.top.cpd27.01 \
        -activebackground gray -background lightgray -borderwidth 1 \
        -command {.monitor.top.cpd27.03 xview} \
        -highlightbackground lightgray -orient horiz -troughcolor gray90 \
        -width 10 
    scrollbar .monitor.top.cpd27.02 \
        -activebackground gray -background lightgray -borderwidth 1 \
        -command {.monitor.top.cpd27.03 yview} \
        -highlightbackground lightgray -orient vert -troughcolor gray90 \
        -width 10 
    text .monitor.top.cpd27.03 \
        -background #bebebe -font -*-courier-medium-r-normal--*-120-* \
        -foreground black -height 1 -highlightbackground lightgray \
        -insertbackground black -selectbackground lightblue \
        -selectborderwidth 0 -selectforeground black -width 8 \
        -xscrollcommand {.monitor.top.cpd27.01 set} \
        -yscrollcommand {.monitor.top.cpd27.02 set} 
    frame .monitor.top.graphs \
        -background lightgray -borderwidth 1 -height 30 \
        -highlightbackground lightgray -relief sunken -width 30 

    blt_barchart .monitor.top.graphs.cpd34 \
        -background #bebebe -borderwidth 1 \
        -font -Adobe-Helvetica-Medium-R-Normal--*-120-* -foreground black \
        -halo 9 -height 180 -invertxy 1 -plotbackground lightgray \
        -relief sunken -width 173
 
    blt_barchart .monitor.top.graphs.cpd36 \
        -background #bebebe -borderwidth 2 \
        -font -Adobe-Helvetica-Medium-R-Normal--*-120-* -foreground black \
        -halo 9 -height 180 -invertxy 1 -plotbackground lightgray \
        -relief sunken -width 173
    blt_graph .monitor.top.graphs.cpd35 \
        -background #bebebe -borderwidth 1 \
        -font -Adobe-Helvetica-Medium-R-Normal--*-120-* -foreground black \
        -halo 9 -height 180 -plotbackground lightgray -relief sunken \
        -width 173
    frame .monitor.top.bottom \
        -background lightgray -borderwidth 1 -height 30 \
        -highlightbackground lightgray -relief sunken -width 30 
    label .monitor.top.bottom.statuslabel \
        -anchor w -background lightgray -borderwidth 0 \
        -font -Adobe-Helvetica-Bold-R-Normal--*-120-* -foreground black \
        -highlightbackground lightgray -padx 12 -relief groove \
        -text {Online help} 
    label .monitor.top.bottom.status \
        -anchor w -background #bebebe -borderwidth 1 \
        -font -Adobe-Helvetica-Bold-R-Normal--*-120-* -foreground black \
        -highlightbackground lightgray -padx 12 -relief sunken 
    ###################
    # SETTING GEOMETRY
    ###################
    place .monitor.top \
        -x 0 -y 0 -relwidth 1 -relheight 1 -anchor nw -bordermode ignore 
    pack .monitor.top.controls \
        -anchor center -expand 0 -fill x -side top 
    pack .monitor.top.controls.cleanup \
        -anchor center -expand 0 -fill none -side left 
    pack .monitor.top.controls.cleanup.arm \
        -anchor center -expand 0 -fill none -side left 
    pack .monitor.top.controls.cleanup.cleanup \
        -anchor center -expand 0 -fill none -side left 
    pack .monitor.top.controls.cleanup.warning \
        -anchor center -expand 0 -fill none -side top 
    pack .monitor.top.cpd27 \
        -anchor center -expand 1 -fill both -side top 
    grid columnconf .monitor.top.cpd27 0 -weight 1
    grid rowconf .monitor.top.cpd27 0 -weight 1
    grid .monitor.top.cpd27.01 \
        -column 0 -row 1 -columnspan 1 -rowspan 1 -sticky ew 
    grid .monitor.top.cpd27.02 \
        -column 1 -row 0 -columnspan 1 -rowspan 1 -sticky ns 
    grid .monitor.top.cpd27.03 \
        -column 0 -row 0 -columnspan 1 -rowspan 1 -sticky nesw 
    pack .monitor.top.graphs \
        -anchor center -expand 0 -fill x -side top 
    pack .monitor.top.graphs.cpd34 \
        -anchor nw -expand 1 -fill both -side left 
    pack .monitor.top.graphs.cpd36 \
        -anchor nw -expand 1 -fill both -side left 
    pack .monitor.top.graphs.cpd35 \
        -anchor nw -expand 1 -fill both -side left 

    pack .monitor.top.bottom \
        -anchor center -expand 0 -fill x -side top 
    pack .monitor.top.bottom.statuslabel \
        -anchor center -expand 0 -fill none -side left 
    pack .monitor.top.bottom.status \
        -anchor center -expand 1 -fill x -side left 
}

proc vTclWindow.placeholder {args} {
    set base .placeholder
    if {[winfo exists .placeholder]} {
        wm deiconify .placeholder; return
    }
    ###################
    # CREATING WIDGETS
    ###################
    toplevel .placeholder -class Toplevel \
        -background lightgray -highlightbackground lightgray 
    wm focusmodel .placeholder passive
    wm geometry .placeholder 200x30+0+0
    wm maxsize .placeholder 1137 870
    wm minsize .placeholder 1 1
    wm overrideredirect .placeholder 1
    wm resizable .placeholder 1 1
    wm deiconify .placeholder
    wm title .placeholder "placeholder"
    frame .placeholder.top \
        -background lightgray -borderwidth 1 -height 30 \
        -highlightbackground lightgray -relief sunken -width 30 
    label .placeholder.top.label \
        -anchor w -background lightgray -borderwidth 0 \
        -font -Adobe-Helvetica-Bold-R-Normal--*-120-* -foreground black \
        -highlightbackground lightgray -relief groove \
        -text {Restore CODA monitor} 
    button .placeholder.top.restore \
        -activebackground gray -activeforeground black -background lightgray \
        -command {wm deiconify .monitor
	    wm withdraw .placeholder} \
        -font -Adobe-Helvetica-Medium-R-Normal--*-120-* -foreground black \
        -highlightbackground lightgray -image icon_button -padx 11 -pady 4 \
        -text button 
    ###################
    # SETTING GEOMETRY
    ###################
    pack .placeholder.top \
        -anchor center -expand 0 -fill both -side top 
    pack .placeholder.top.label \
        -anchor center -expand 1 -fill x -side left 
    pack .placeholder.top.restore \
        -anchor center -expand 0 -fill none -side left 
}

proc vTclWindow.splash {args} {
    set base .splash
    if {[winfo exists .splash]} {
        wm deiconify .splash; return
    }
    ###################
    # CREATING WIDGETS
    ###################
    toplevel .splash -class tkSplash \
        -background lightgray -highlightbackground lightgray 
    wm focusmodel .splash passive
    wm geometry .splash 427x328+364+261
    wm maxsize .splash 1137 870
    wm minsize .splash 1 1
    wm overrideredirect .splash 0
    wm resizable .splash 1 1
    wm title .splash "splash"
    label .splash.splash \
        -anchor w -background lightgray -borderwidth 0 \
        -font -Adobe-Helvetica-Bold-R-Normal--*-120-* -foreground black \
        -highlightbackground lightgray -image splash_creen -relief groove \
        -text label 
    ###################
    # SETTING GEOMETRY
    ###################
    place .splash.splash \
        -x 0 -y 0 -anchor nw -bordermode ignore 
}

#Window show .
#Window show .splash
#Window show .monitor 
#Window show .placeholder

#main 0 {}
