
class DIALOG {

    constructor {args} {} 
    destructor {} 

    public  method setscreen {s} {}
    public  method position {w} {}
    private method create   {w} {}
    private method name     {w lines bm} {}
    private method buttons  {w blist} {}

    public  method table_result {w button} {}
    public  method request_callback { w tlist button } {}
    public  method select_year {s} {}
    public  method select_month {s} {}
    public  method select_day {s} {}
    public  method select_hour {s} {}
    public  method select_min {s} {}
    public  method select_sec {s} {}
    public  method okcmd {w} {}

    private variable widget ""
    private variable screen ""
    private variable confirm_result ""
    private variable table_result ""
    private variable general_result ""
    private variable request_result ""
    public  variable filename_result ""
    public  variable time_result ""

    private  variable month ""
    private  variable year ""
    private  variable day ""
    private  variable hour ""
    private  variable min ""
    private  variable sec ""

    public method date { title time } {}
    public method general  {c args} {}
    public method acknowledge {c args} {}
    public method confirm  {c args} {}
    public method browse   {c args} {}
    public method table    {c args} {}
    public method request   {c args} {}
    public method fileselect {c title dir args} {}
    public method result {name {value ""}} {}

}

body DIALOG::result {name {value ""}} {
    if {$value != ""} {
	set ${name}_result $value
    } else {
	return [set ${name}_result]
    }
}

body DIALOG::constructor {args} {
}

body DIALOG::destructor {} {
}

body DIALOG::setscreen {s} {
    set screen $s
}

body DIALOG::position {w} {
    set top [winfo toplevel $widget]
    wm withdraw $w
    update idletasks
    
    set x [expr {[winfo rootx $top]+[winfo vrootx $top]+100}]
    set y [expr {[winfo rooty $top]+[winfo vrooty $top]+100}]
	
    if {$x < 0} { set x 0 }
    
    if {$y < 0} { set y 0 }
    
    wm geometry $w +$x+$y
    wm deiconify $w    
}

##
## Make a dialog toplevel window with the given dialog name.
##

body DIALOG::create {w} {
    
    catch {destroy $w}
    if {$screen != ""} {
	toplevel $w -screen $screen
    } else {
	toplevel $w
    }
    set widget $w
}

##
## Make a title for a dialog. Create a message containing the lines
## given in the lines argument.
##

body DIALOG::name {w lines {bm info}} {
    set text ""
    frame $w
    foreach line $lines { append text "$line\n" }
    message $w.m -aspect 25000 -text $text
    label $w.l -bitmap $bm
    pack $w.l -padx 10 -side left -in $w 
    pack $w.m -side left -in $w
    
    pack $w -side top
}

##
## Most dialogs have a list of buttons in the bottom. This proc
## creates these buttons and makes the first one the default.
##

body DIALOG::buttons {w args} {
    tixButtonBox $w.box -orientation horizontal
    
    foreach button $args {
	foreach arg $button {
	    $w.box add [lindex $arg 0] -text [lindex $arg 0] \
		-command "[lindex $arg 1];destroy $w" \
		-width 5
	}
    }
    pack $w.box -side bottom -fill both
    
}

body DIALOG::date { name  time } {
    set w ".tkdate"
    
    create $w
    name $w.title [list $name] question
    set $this::month junk
    set $this::year  test

    frame $w.top -border 1 -relief raised

    tixComboBox $w.top.a -label "Month: " -dropdown true \
	-command "$this select_month" -editable false \
	-options {
	    listbox.height 6
	    entry.width 10
	    label.padY 5
	    label.width 10
	    label.anchor e
	}
    
    tixComboBox $w.top.b -label "Year: " -dropdown true \
	-command "$this select_year" -editable true \
	-options {
	    listbox.height 6
	    entry.width 10
	    label.padY 5
	    label.width 10
	    label.anchor ne
	}

    tixControl $w.top.c -label "Day: " -integer true \
	-command "$this select_day" -min 1 -max 31\
	-options {
	    entry.width 10
	    label.padY 5
	    label.width 10
	    label.anchor ne
	}


    tixControl $w.top.d -label "Hours: " -integer true \
	-command "$this select_hour" -min 0 -max 23\
	-options {
	    entry.width 10
	    label.padY 5
	    label.width 10
	    label.anchor ne
	}

    tixControl $w.top.e -label "Minutes: " -integer true \
	-command "$this select_min" -min 0 -max 60\
	-options {
	    entry.width 10
	    label.padY 5
	    label.width 10
	    label.anchor ne
	}

    tixControl $w.top.f -label "Seconds: " -integer true \
	-command "$this select_sec" -min 0 -max 60\
	-options {
	    entry.width 10
	    label.padY 5
	    label.width 10
	    label.anchor ne
	}

    pack $w.top.a -side top -anchor w
    pack $w.top.b -side top -anchor w
    pack $w.top.c -side top -anchor w
    pack $w.top.d -side top -anchor w
    pack $w.top.e -side top -anchor w
    pack $w.top.f -side top -anchor w

    # Insert the choices into the combo boxes
    #
    $w.top.a insert end January
    $w.top.a insert end February
    $w.top.a insert end March
    $w.top.a insert end April
    $w.top.a insert end May
    $w.top.a insert end June
    $w.top.a insert end July
    $w.top.a insert end August
    $w.top.a insert end September
    $w.top.a insert end October
    $w.top.a insert end November
    $w.top.a insert end December

    $w.top.b insert end 1995
    $w.top.b insert end 1996
    $w.top.b insert end 1997
    $w.top.b insert end 1998
    $w.top.b insert end 1999
    $w.top.b insert end 2000
    $w.top.b insert end 2001
    $w.top.b insert end 2002
    $w.top.b insert end 2003
    $w.top.b insert end 2004

    if {$time == ""} {
	set time [ns_systime]
    }
    select_month [ns_ctime $time %B]
    select_year  [ns_ctime $time %Y]
    select_day  [ns_ctime $time %e]
    select_hour  [ns_ctime $time %H]
    select_min  [ns_ctime $time %M]
    select_sec  [ns_ctime $time %S]

    
    # Use a ButtonBox to hold the buttons.
    #
    tixButtonBox $w.box -orientation horizontal
    $w.box add ok     -text Ok     -underline 0 -command "$this okcmd $w" \
	-width 6
    $w.box add cancel -text Cancel -underline 0 -command "destroy $w" \
	-width 6

    pack $w.box -side bottom -fill x
    pack $w.top -side top -fill both -expand yes

    tkwait window $w
    
}

body DIALOG::select_year {s} {
    tixSetSilent $widget.top.b $s
    set year $s
}

body DIALOG::select_month {s} {
    tixSetSilent $widget.top.a $s
    set month $s
    switch $month {
	January {set max 31}
	February {
	    if { [expr ($year/4) *4 ] == $year} {
		set max 29
	    } else { 
		set max 28
	    }
	}
	March {set max 31}
	April {set max 30}
	May {set max 31}
	June {set max 30}
	July {set max 31}
	August {set max 31}
	September {set max 30}
	October {set max 31}
	November {set max 30}
	December {set max 31}
    }
    $widget.top.c config -max $max
    if { $day > $max } {
	select_day $max
    }
}

body DIALOG::select_day {s} {
    set day $s
    tixSetSilent $widget.top.c $s
}

body DIALOG::select_hour {s} {
    set hour $s
    tixSetSilent $widget.top.d $s
}

body DIALOG::select_min {s} {
    set min $s
    tixSetSilent $widget.top.e $s
}

body DIALOG::select_sec {s} {
    set sec $s
    tixSetSilent $widget.top.f $s
}

body DIALOG::okcmd {w} {
    destroy $w
    set time_result [ns_ptime "$year $month $day $hour $min $sec" "%Y %B %e %H %M %S"]
}


    

##
## An acknowledge dialog takes its arguments, puts them into a
## message and displays them until the user hits the dismiss 
## button.
##

body DIALOG::general {c args} {
    
    set general_result ""
    set w ".tkgeneral"
    
    create $w
    
    set idx [llength $args]; incr idx -1
    set buttons [lindex $args $idx]; incr idx -1
    
    name $w.title [lrange $args 0 $idx]
    
    if {$buttons == ""} { set buttons dismiss } 
    foreach button $buttons {
	lappend foobar [list $button "$this result general $button"]
    }
    buttons $w $foobar
    position $w
    
    grab set $w
    tkwait window $w
    return $general_result
}

##
## An acknowledge dialog takes its arguments, puts them into a
## message and displays them until the user hits the dismiss 
## button.
##

body DIALOG::acknowledge {c args} {
    set w ".tkacknowledge"
    
    create $w
    name $w.title $args
    buttons $w "dismiss"
    
    position $w
    grab set $w
    tkwait window $w
}

##
## A confirm dialog takes its arguments, puts them into a
## message and displays them until the user hits the yes, no
## or cancel button.
##

body DIALOG::confirm {c args} {
    
    set confirm_result ""
    set w ".tkconfirm"
    
    create $w
    set idx [llength $args]; incr idx -1
    set buttons [lindex $args $idx]; incr idx -1
    name $w.title [lrange $args 0 $idx]
    
    if {$buttons == ""} { set buttons dismiss }    
    foreach button $buttons {
	lappend foobar [list $button "$this result confirm $button"]
    }
    buttons $w $foobar
    
    position $w
    grab set $w
    tkwait window $w
}

##
## Browse a long list of text. This dialog opens a text widget
## with a scrollbar. The dialog is finished when the dismiss
## button is invoked.
##

body DIALOG::browse {c args} {
    set w ".tkbrowse"
    create $w
    set idx [llength $args]; incr idx -1
    set lastarg [lindex $args $idx]; incr idx -1
    name $w.title [lrange $args 0 $idx]
    regsub "\n" $lastarg " " lastarg
    
    frame $w.b
    set width 20
    set height 1
    set msg ""
    foreach line $lastarg {
	if {$line == "\n"} continue
	set line [string trimright $line]
	append msg "$line\n"
	set len [string length $line]
	if {$len>$width} { set width $len }
	incr height
    }
    if {$height>24} { set height 24 }
    incr width
    
    set scroll [expr {$height > 10}]
    
    if {$scroll} {
	text $w.b.txt -width $width -height $height \
	    -yscrollcommand "$w.b.scrollbar set" -setgrid true \
	    -borderwidth 2 -relief flat -wrap none
	scrollbar $w.b.scrollbar -command "$w.b.txt yview" -relief sunken
    } else {
	text $w.b.txt -width $width -height $height -setgrid true \
	    -borderwidth 2 -relief flat -wrap none
    }
    $w.b.txt insert 0.0 $msg
    $w.b.txt configure -state disabled
    
    if {$scroll} {
	pack $w.b.scrollbar -side right -fill y
    }
    pack $w.b.txt -side left -fill both -expand yes
    pack $w.b  -side top -padx 10 -pady 10 -fill both -expand yes
    buttons $w "dismiss"
    
    position $w
    grab set $w
    tkwait window $w
}

##
## This dialog displays a list and lets the users select items from
## the list. It returns the list of selected items.
##

body DIALOG::table {c args} {
    set table_result ""
    set w ".tklist"
    
    create $w
    set idx [llength $args]; incr idx -1
    set buttons [lindex $args $idx]; incr idx -1
    set lastarg [lindex $args $idx]; incr idx -1
    name $w.title [lrange $args 0 $idx]
    
    # compute the width and height of the listbox
    set width 24
    set height 8
    foreach elem $lastarg {
	set l [string length $elem]
	incr l
	if {($l > $width) && ($l <= 80)} {
	    set width $l
	}
    }
    set h [llength $lastarg]
    if {($h > $height)} {
	set height [expr {($h <= 24) ? $h : 24}]
    }
    
    frame $w.box
    scrollbar $w.box.scroll -command "$w.box.list yview" -relief sunken
    listbox $w.box.list -yscroll "$w.box.scroll set" -relief sunken \
	-width $width -height $height
    foreach elem $lastarg {
	$w.box.list insert end $elem
    }
    pack $w.box.scroll -side right -fill y
    pack $w.box.list -side left -expand true -fill both
    pack $w.box -side top -padx 10 -pady 10 -expand true -fill both
    
    if {$buttons == ""} { set buttons dismiss }
    foreach button $buttons {
	lappend foobar [list $button "$this::table_result $w $button"]
    }
    buttons $w $foobar
    
    bind $w.box.list <Double-Button-1> \
	"%W selection set \[%W nearest %y\];
         table_result $w {}; destroy $w; break"
    
    position $w
    grab set $w
    tkwait window $w
    return $table_result
}

body DIALOG::table_result { w button } {
    set table_result [list $button]
    set done 0
    foreach i [$w.box.list curselection] {
	lappend $this::table_result [$w.box.list get $i]
	set done 1
    }
    if {! $done} {
	lappend $this::table_result ""
    }
}

##
## A request dialog displays a message and asks the user to enter
## something in a request box. The last argument is a default for
## the entry widget.
##

body DIALOG::request {c args} {
    set w ".tkrequest"
    set request_result ""
    
    create $w
    set idx [llength $args]; incr idx -1
    set buttons [lindex $args $idx]; incr idx -1
    set lastarg [lindex $args $idx]; incr idx -1
    name $w.title [lrange $args 0 $idx] question
    
    set idx 1
    set tlist ""
    frame $w.ia
    frame $w.ia.msg
    frame $w.ia.entry
    foreach elem $lastarg {
	message $w.ia.msg.$idx -aspect 25000 -text [lindex $elem 0]
	pack $w.ia.msg.$idx -side top -pady 1
	switch [lindex $elem 2] {
	    scale {
		frame $w.ia.entry.$idx
		label $w.ia.entry.$idx.l -width 4 -font fixed
		scale $w.ia.entry.$idx.s -orient h -label "" -showvalue false \
		    -command "$w.ia.entry.$idx.l configure -text"
		set from [expr round([lindex $elem 3])]
		set to   [expr round([lindex $elem 4])]
		if {[lindex $elem 3] != ""} {
		    catch {$w.ia.entry.$idx.s configure -from $from}
		}
		if {[lindex $elem 4] != ""} {
		    catch {$w.ia.entry.$idx.s configure -to $to}
		}
		set val [expr round([lindex $elem 1])]
		catch {$w.ia.entry.$idx.s set $val} err
		pack $w.ia.entry.$idx.l -side left
		pack $w.ia.entry.$idx.s -side right -fill x -expand true
		pack $w.ia.entry.$idx -side top -fill both -expand true 
	    }
	    logscale {
		frame $w.ia.entry.$idx
		label $w.ia.entry.$idx.l -width 4 -font fixed
		scale $w.ia.entry.$idx.s -orient h -label "" -showvalue false \
		    -command "$w.ia.entry.$idx.l configure -text"
		set from [expr round(exp([lindex $elem 3]))]
		set to [expr round(exp([lindex $elem 4]))]
		if {[lindex $elem 3] != ""} {
		    catch {$w.ia.entry.$idx.s configure -from $from}
		}
		if {[lindex $elem 4] != ""} {
		    catch {$w.ia.entry.$idx.s configure -to $to}
		}
		set val [expr round(exp([lindex $elem 1]))]
		catch {$w.ia.entry.$idx.s set $val}
		pack $w.ia.entry.$idx.l -side left
		pack $w.ia.entry.$idx.s -side right -fill x -expand true
		pack $w.ia.entry.$idx -side top -fill both \
		    -expand true -padx 1 -pady 1
	    }
	    radio {
		frame $w.ia.entry.$idx
		set i 0
		foreach word [lrange $elem 3 end] {
		    radiobutton $w.ia.entry.$idx.$i -text $word -relief flat \
			-variable request_value_$idx -value $word
		    pack $w.ia.entry.$idx.$i -side left -fill x -expand true
		    if {$word == [lindex $elem 1]} {
			catch { $w.ia.entry.$idx.$i invoke }
		    }
		    incr i
		}
		pack $w.ia.entry.$idx -side top -fill both \
		    -expand true -padx 1 -pady 1
	    }
	    check {
		frame $w.ia.entry.$idx
		global request_value
		set i 0
		foreach word [lrange $elem 3 end] {
		    set request_value($idx,$i) ""
		    checkbutton $w.ia.entry.$idx.$i -text $word -relief flat \
			-variable request_value($idx,$i) \
			-offvalue "" -onvalue $word
		    pack $w.ia.entry.$idx.$i -side left -fill x -expand true
		    if {[lsearch [lindex $elem 1] $word] >= 0} {
			catch { $w.ia.entry.$idx.$i invoke }
		    }
		    incr i
		}
		pack $w.ia.entry.$idx -side top -fill both \
		    -expand true -padx 1 -pady 1
	    }
	    option {
		eval tk_optionMenu $w.ia.entry.$idx \
		    request_value_$idx [lrange $elem 3 end]
		$w.ia.entry.$idx configure \
		    -highlightthickness 0 -pady 0
		[winfo child $w.ia.entry.$idx] configure -tearoff false 
		pack $w.ia.entry.$idx -side top -fill both \
		    -expand true -padx 1 -pady 2
	    }
	    entry {
		entry $w.ia.entry.$idx -width [lindex $elem 3] -relief sunken
		$w.ia.entry.$idx insert 0 [lindex $elem 1]
		pack $w.ia.entry.$idx -side top -fill both \
		    -expand true -padx 1 -pady 2
	    }
	    default {
		entry $w.ia.entry.$idx -width 40 -relief sunken
		$w.ia.entry.$idx insert 0 [lindex $elem 1]
		pack $w.ia.entry.$idx -side top -fill both \
		    -expand true -padx 1 -pady 2
	    }
	}
	
	lappend tlist [lindex $elem 2]
	incr idx
    }
    pack $w.ia.msg -side left
    pack $w.ia.entry -side right -padx 10
    pack $w.ia -side top
    
    if {$buttons == ""} { set buttons dismiss }
    foreach button $buttons {
	lappend foobar [list $button "$this request_callback $w \{$tlist\} $button"]
    }
    
    buttons $w $foobar
    position $w
    grab set $w
    tkwait window $w

    return $request_result
}

body DIALOG::request_callback { w tlist button } {
    set idx 1
    set request_result [list $button]
    foreach t $tlist {
	switch $t {
	    scale {
		set val [$w.ia.entry.$idx.s get]
		lappend $this::request_result $val
	    }
	    logscale {
		set val [$w.ia.entry.$idx.s get]
		lappend $this::request_result [expr log($val)]
	    }
	    radio {
		global request_value_$idx
		lappend $this::request_result [set request_value_$idx]
	    }
	    check {
		global request_value
		set aa ""
		    foreach name [array names request_value] {
			if {[string match "$idx,*" $name]} {
			    if {$request_value($name) != ""} {
				lappend aa $request_value($name)
			    }
			}
		    }
		lappend $this::request_result $aa
	    }
	    option {
		global request_value_$idx
		lappend $this::request_result [set request_value_$idx]
	    }
	    default {
		lappend $this::request_result [$w.ia.entry.$idx get]
	    }
	}
	incr idx
    }
    
}

##
## fileselect builds the browser and fires file_select_browse
## which does the real job.
##

body DIALOG::fileselect {c {title {File:}} {dir {}} args} {
    toplevel .tkw
    set widget .tkw

    wm withdraw $w
    $this position $w

    update
    
    frame $w.top -border 1 -relief raised
    
    
    tixFileEntry $w.top.a -label "$title" \
	-variable $this::filename_result\
	-command "$this result filename" \
	-options {
	    entry.width 25
	    label.width 16
	    label.underline 10
	    label.anchor e
	}
    [.tkw.top.a filedialog] subwidget fsbox config -pattern *.log
    
    pack $w.top.a  -side top -anchor w -pady 3
    
    # Use a ButtonBox to hold the buttons.
    #
    tixButtonBox $w.box -orientation horizontal
    
    $w.box add cancel -text Cancel -underline 0 -command "
	set $this::filename_result {}
    " -width 6
    
    pack $w.box -side right -fill x
    pack $w.top -side left  -fill both -expand yes
    
    wm deiconify $w

    dp_waitvariable $this::filename_result 

    destroy $w
}
