/*-----------------------------------------------------------------------------
 * Copyright (c) 1991,1992 Southeastern Universities Research Association,
 *                         Continuous Electron Beam Accelerator Facility
 *
 * This software was developed under a United States Government license
 * described in the NOTICE file included as part of this distribution.
 *
 * CEBAF Data Acquisition Group, 12000 Jefferson Ave., Newport News, VA 23606
 * Email: coda@cebaf.gov  Tel: (804) 249-7101  Fax: (804) 249-7363
 *-----------------------------------------------------------------------------
 * 
 * Description:
 *	Utility for Trigger Supervisor RPC calls (client program)
 *	
 * Author David Abbott, CEBAF Data Acquisition Group
 *
 */

#include <stdio.h>
#include <string.h>

#include <ts.h>

void tsPrint();

main(argc,argv)
     int argc;
     char *argv[];
{
  int val,lstat,x;
  int stat;
  char line[80];
  char command[80];

  if (argc<2) {
    printf("Usage: tsp target [command]\n");
    return;
  }

  tsopen(argv[1],&stat);
  if (stat!=1) {
    printf("failed to establish connection to target machine %s\n",argv[1]);
    printf("Usage: tsp target [command]\n");
    return;
  }


  if (argc==3) {
    sprintf(line,"%s\0",argv[2]);
    sscanf(line,"%s",&command[0]);
    if (strncmp(command,"enable",6) == 0) {
      tsGo(1);
      lstat = tsStatus(0);
      if(lstat&TS_CSR_GO) printf(" TS enabled\n");
    } else if (strncmp(command,"disable",7) == 0) {
      tsStop(1);
      lstat = tsStatus(0);
      if((lstat&TS_CSR_GO) == 0) printf(" TS disabled\n");
    } else if (strncmp(command,"status",6) == 0) {
      lstat = tsStatus(1);
      tsPrint(lstat);
    } else if (strncmp(command,"init",4) == 0) {
      ts_init_1(0,1);
      lstat = tsStatus(2);
      tsPrint(lstat);
    } else {
      printf("Bad argument\n");
      printf("  Options: enable, disable, init, status\n");
    }
    printf("\n");

  } else if (argc==2) {
    printf("Successful connection established to %s\n",argv[1]);
    printf("TS command: ");
    while (gets(line)!=NULL) {
      sscanf(line,"%s",&command[0]);
      if (strncmp(command,"enable",6) == 0) {
	tsGo(1);
	lstat = tsStatus(0);
	if(lstat&TS_CSR_GO) printf(" TS enabled\n");
      } else if (strncmp(command,"disable",7) == 0) {
	tsStop(1);
	lstat = tsStatus(0);
	if((lstat&TS_CSR_GO) == 0) printf(" TS disabled\n");
      } else if (strncmp(command,"status",6) == 0) {
	lstat = tsStatus(1);
	tsPrint(lstat);
      } else if (strncmp(command,"init",4) == 0) {
	ts_init_1(0,1);
	lstat = tsStatus(2);
	tsPrint(lstat);
      } else if(strncmp(command,"exit",4) == 0) {
	break;
      } else {
	printf("Bad argument\n");
	printf("  Options: enable\n");
	printf("           disable\n");
	printf("           init\n");
	printf("           status\n");
	printf("           exit\n");
      }
      printf("TS command: ");
    }
    printf("\n");
  } else {
    printf("Invalid number of arguments\n");
    printf("Usage: tsp target [command]\n");
  }

  printf("Goodbye\n");
  exit(0);
}


void tsPrint (int stat)
{
  printf("  TS Status: 0x%x\n",stat);
  if (stat&TS_CSR_GO)
    printf("    Go      : Enabled\n");
  else
    printf("    Go      : Disabled\n");

  if (stat&TS_CSR_ENL1)
    printf("    L1      : Enabled\n");
  else
    printf("    L1      : Disabled\n");

  if (stat&TS_CSR_ROCLOCK)
    printf("    Unbuffered Mode\n");
  else
    printf("    Buffered Mode\n");
}
