/* Macros for accessing the Jefferson Lab
   Trigger Supervisor Module  */

/* Trigger Supervisor Macros */
#ifdef VXWORKS

#define TSCSR(m)                {tsP->csr = m;}
#define TSROC(b4,b3,b2,b1)      {tsP->roc = (b4<<24)|(b3<<16)|(b2<<8)|(b1);}
#define TSTRIG(m)               {tsP->trig = m;}
#define TSSYNC(c)               {tsP->sync = c;}
#define TSTEST(m)               {tsP->test = m;}

#define TSINIT                 TSCSR(TS_INIT_MASK)
#define TSRESET                TSCSR(TS_RESET_MASK)
#define TSGO                   TSCSR(TS_GO_MASK)
#define TSENL1                 TSCSR(TS_ENL1_MASK)
#define TSENSYNC               TSCSR(TS_ENSYNC_MASK)
#define TSROCLOCK              TSCSR(TS_ROCLOCK_MASK)

#define TSENABLED              ((tsP->csr)&TS_CSR_GO)
#define L1ENABLED             ((tsP->csr)&TS_CSR_ENL1)

#define TSPRESCALE(p,c)        {tsP->prescale[p] = c;}
#define TSTIMER(t,c)           {tsP->timer[t] = c;}

#endif


