# 	struct.rc (for Tcl)
puts {Testing the use of 'struct' with Tcl
}
#struct_info debug +refcount

set intrinsic [struct_info types]

puts {
    Sizes of types}
foreach type $intrinsic {
	puts "Size of $type is [struct_info sizeof $type]"
}

puts ""
puts "Defining structure ..."
#struct_info debug +all
struct_typedef combined {struct
	{int anint}
	{ushort ashort}
	{char achar1}
	{char achar2}
	{^short aptr}
}
puts "Display size ..."
puts "Size of combined is [struct_info sizeof combined]"

puts "Allocate object"
puts [struct_new obj combined]
puts "okay"
#struct_info debug +all
foreach elem {aptr aptr._hex_} {
	puts "  obj($elem) = '$obj($elem)'"
}

#struct_info debug -all +refcount
puts "Size of obj is [struct_info sizeof obj]"
puts "Size of combined is [struct_info sizeof combined]"
# struct_info debug +all
set obj(_char_) {ABCDEFGHIJKL}

foreach elem {_hex_ anint ashort achar1 achar2 ashort._hex_ achar2._hex_ ashort._char_ _char_} {
	puts "  obj($elem) = '$obj($elem)'"
}

puts ""
# struct_typedef linebuf char*32
struct_new linebuf char*32
foreach elem {_hex_ 2 2._hex_} {
	puts "  linebuf($elem) = '$linebuf($elem)'"
}

#struct_info debug +all
puts "  obj() = '$obj()'"

struct_typedef link1 {struct {^link1 next} {int count}}

# exit
