'\" @(#)tclStruct:types.n	1.3	95/09/12
.so man.macros
.TH structtypes n "" TclStruct "TclStruct Built-In Commands"
.BS
.SH NAME
structtypes \- Built in types
.BE

.SH DESCRIPTION
.PP
The TclStruct package has the following predefined types.
Their sizes and ranges are tied to the machine on which they are
operating.  The sizes and ranges listed are correct for most
machines:
.IP \fBchar\fR
.br
This type occupies a single unsigned byte.  Its external
representation is as string with its contents being the single
character at its location.
If the nullok flag is set, then the empty string represents the nul
character, otherwise it is an error to read or write the null character.
If the strict flag is set, then it is an error to write more than a
single character, otherwise the first character in the string is
written to the character.
The built-in \fBchar\fR type has the nullok and strict flags set.
.IP ""
The \fBchar\fR type is special in that arrays of chars
are a \fBbasic\fR type and are handled specially as strings.
.IP \fBbyte\fR
.br
This type denotes a signed binary quantity occupying a single byte
and having a range of -128 to 127.
.IP \fBubyte\fR
.br
This type denotes a unsigned binary quantity occupying a single byte
and having a range of 0 to 255.
.br
.IP \fBshort\fR
.br
This type denotes a signed binary quantity occupying two bytes
and having a range of -32768 to 32767.
.IP \fBushort\fR
.br
This type denotes a unsigned binary quantity occupying two bytes
and having a range of 0 to 65535.
.IP \fBint\fR
.br
This type denotes a signed binary quantity occupying four bytes
and having a range of -2147483648 to 2147483647.
.IP \fBuint\fR
.br
This type denotes a unsigned binary quantity occupying four bytes
and having a range of 0 to 4294967295.
.br
.IP \fBlong\fR
.br
This type denotes a signed binary quantity occupying four bytes
and having a range of -2147483648 to 2147483647.
.IP \fBulong\fR
.br
This type denotes a unsigned binary quantity occupying four bytes
and having a range of 0 to 4294967295.
.br
.IP \fBfloat\fR
.br
This type denotes a single precision floating point quantity.
It normally occupies 4 bytes.
.IP \fBdouble\fR
.br
This type denotes a double precision floating point quantity.
It normally occupies 8 bytes.
.br
.IP \fBhex\fR
.br
This type occupies a single unsigned byte.  Its external representation
consists of 2 hexadecimal digits.
An array of \fBhex\fR has a special representation consisting of
a string with exactly 2 hexadecimal digits for each byte in the array.
.IP \fBstr\fR
.br
The \fBstring\fR type consists of a pointer to a malloc'd, nul
terminated, string.  Setting a \fBstring\fR value will \fBfree\fR
any previous value and then \fBmalloc\fR(3) a new buffer with
the new contents of the string.
If the nullok flag is set, then reading a null pointer will return
the empty string, and writing the empty string will set a null pointer.
The built-in \fBstr\fR type has the nullok flag set.
.IP ""
Since the \fBstring\fR is a pointer to a character array, array
indexing may be used to access individual characters within the
bounds of the string.

.SH KEYWORDS
type, struct
